/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class ThermometerGraphic
extends PNode {
    private static Color s_color = Color.red;
    private static Color s_outlineColor = Color.black;
    private Ellipse2D.Double bulb;
    private NumberFormat formatter = new DecimalFormat("#0");
    private Font font = new PhetFont(1, 10);
    private float columnStrokeWidth = 1.5f;
    private BasicStroke columnStroke = new BasicStroke(this.columnStrokeWidth);
    private Color rectColor = Color.yellow;
    private float readoutRectStrokeWidth = 0.5f;
    private BasicStroke readoutRectStroke = new BasicStroke(this.readoutRectStrokeWidth);
    private PPath fillNode;
    private Rectangle2D columnFill;
    private double bulbRadius = 8.0;
    private double columnWidth = 8.0;
    private double overallHeight = 150.0;
    private MRModel model;
    private double maxModelValue;
    private Rectangle2D column;
    private double fillHeightScale;

    public ThermometerGraphic(MRModel mRModel, IClock iClock, double d, double d2) {
        this.model = mRModel;
        this.maxModelValue = d2;
        this.column = new Rectangle2D.Double(0.0, 0.0, this.columnWidth, this.overallHeight - this.bulbRadius);
        PPath pPath = new PPath(this.column);
        pPath.setPaint(Color.white);
        this.fillHeightScale = (this.overallHeight - this.bulbRadius) / d2;
        PPath pPath2 = new PPath(this.column);
        pPath2.setPaint(new Color(0, 0, 0, 0));
        this.columnFill = new Rectangle2D.Double();
        this.fillNode = new PPath(this.columnFill);
        this.fillNode.setPaint(Color.red);
        this.bulb = new Ellipse2D.Double(0.0, 0.0, this.bulbRadius * 2.0, this.bulbRadius * 2.0);
        PPath pPath3 = new PPath(this.bulb);
        pPath3.setPaint(Color.red);
        this.setPickable(false);
        pPath.setOffset(-this.columnWidth / 2.0, 0.0);
        this.fillNode.setOffset(-this.columnWidth / 2.0, 0.0);
        pPath3.setOffset(-this.bulbRadius, this.overallHeight - this.bulbRadius * 2.0);
        pPath2.setOffset(-this.columnWidth / 2.0, 0.0);
        this.addChild(pPath);
        this.addChild(this.fillNode);
        this.addChild(pPath2);
        this.addChild(pPath3);
        iClock.addClockListener(new Updater());
    }

    public void update() {
        double d = this.model.getTotalEnergy() / 1.5;
        double d2 = Math.min(d, this.maxModelValue);
        double d3 = d2 * this.fillHeightScale;
        this.columnFill.setFrame(0.0, this.column.getHeight() - d3, this.column.getWidth(), d3);
        this.fillNode.setPathTo(this.columnFill);
    }

    private class Updater
    extends ClockAdapter {
        private Updater() {
        }

        public void clockTicked(ClockEvent clockEvent) {
            ThermometerGraphic.this.update();
        }
    }
}

