/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view;

import edu.colorado.phet.common.piccolophet.nodes.RegisterablePNode;
import edu.colorado.phet.common.piccolophet.util.PImageFactory;
import edu.colorado.phet.reactionsandrates.MRConfig;
import edu.colorado.phet.reactionsandrates.model.TemperatureControl;
import edu.colorado.phet.reactionsandrates.util.ControlBorderFactory;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolox.pswing.PSwing;
import edu.umd.cs.piccolox.pswing.PSwingCanvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TemperatureControlGraphic
extends RegisterablePNode
implements TemperatureControl.ChangeListener {
    private PSwingCanvas canvas;
    private TemperatureControl temperatureControl;
    private JSlider stoveSlider;
    private PImage stoveGraphic;
    private PImage flamesGraphic;
    private PImage iceGraphic;
    private double stoveOffsetY = 25.0;
    private volatile boolean adjustmentInProgress = false;

    public TemperatureControlGraphic(PSwingCanvas pSwingCanvas, TemperatureControl temperatureControl) {
        this.canvas = pSwingCanvas;
        this.temperatureControl = temperatureControl;
        temperatureControl.addChangeListener(this);
        this.createImages(this.stoveOffsetY);
        PNode pNode = this.createSlider();
        this.addChild(pNode);
        this.setRegistrationPoint(this.stoveGraphic.getWidth() / 2.0, 0.0);
        this.setOffset(temperatureControl.getPosition());
    }

    private void createImages(double d) {
        this.flamesGraphic = PImageFactory.create("reactions-and-rates/images/flames.gif");
        this.addChild(this.flamesGraphic);
        this.iceGraphic = PImageFactory.create("reactions-and-rates/images/ice.gif");
        this.addChild(this.iceGraphic);
        this.stoveGraphic = PImageFactory.create("reactions-and-rates/images/stove.png");
        this.stoveGraphic.setOffset(0.0, d);
        this.addChild(this.stoveGraphic);
        this.iceGraphic.setOffset((this.stoveGraphic.getWidth() - this.iceGraphic.getWidth()) / 2.0, d);
        this.flamesGraphic.setOffset((this.stoveGraphic.getWidth() - this.flamesGraphic.getWidth()) / 2.0, d);
    }

    private PNode createSlider() {
        int n = 40;
        this.stoveSlider = new JSlider(1, -n, n, 0);
        this.stoveSlider.setMajorTickSpacing(n);
        this.stoveSlider.setMinorTickSpacing(10);
        this.stoveSlider.setSnapToTicks(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(0), new JLabel(MRConfig.RESOURCES.getLocalizedString("Control.0")));
        hashtable.put(new Integer(-40), new MyJLabel(MRConfig.RESOURCES.getLocalizedString("Control.Lower")));
        hashtable.put(new Integer(40), new MyJLabel(MRConfig.RESOURCES.getLocalizedString("Control.Raise")));
        this.stoveSlider.setLabelTable(hashtable);
        this.stoveSlider.setPaintTicks(true);
        this.stoveSlider.setSnapToTicks(true);
        this.stoveSlider.setPaintLabels(true);
        this.stoveSlider.setPreferredSize(new Dimension(100, 60));
        this.stoveSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (TemperatureControlGraphic.this.stoveSlider.getValueIsAdjusting()) {
                    TemperatureControlGraphic.this.adjustmentInProgress = true;
                } else {
                    TemperatureControlGraphic.this.adjustmentInProgress = false;
                }
                TemperatureControlGraphic.this.temperatureControl.setSetting(TemperatureControlGraphic.this.stoveSlider.getValue());
            }
        });
        this.stoveSlider.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                TemperatureControlGraphic.this.stoveSlider.setValue(0);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                super.mousePressed(mouseEvent);
            }
        });
        this.stoveSlider.setBorder(ControlBorderFactory.createPrimaryBorder(MRConfig.RESOURCES.getLocalizedString("Control.Heat_Control")));
        Color color = MRConfig.SPATIAL_VIEW_BACKGROUND;
        this.stoveSlider.setBackground(color);
        this.stoveSlider.setPreferredSize(new Dimension(this.stoveSlider.getPreferredSize().width, 100));
        PSwing pSwing = new PSwing(this.stoveSlider);
        pSwing.setOffset(this.stoveGraphic.getWidth() + 5.0, 0.0);
        return pSwing;
    }

    public boolean isTemperatureBeingAdjusted() {
        return this.adjustmentInProgress;
    }

    public void settingChanged(double d) {
        this.stoveSlider.setValue((int)d);
        double d2 = this.stoveOffsetY - d;
        double d3 = this.stoveOffsetY + d;
        this.flamesGraphic.setOffset(this.flamesGraphic.getOffset().getX(), (int)Math.min(d2, this.stoveOffsetY));
        this.iceGraphic.setOffset((int)this.iceGraphic.getOffset().getX(), (int)Math.min(d3, this.stoveOffsetY));
    }

    public void positionChanged(Point2D point2D) {
        this.setOffset(point2D);
    }

    class MyJLabel
    extends JLabel {
        public MyJLabel(String string) {
            super(string);
        }

        public Dimension getPreferredSize() {
            return super.getPreferredSize();
        }
    }
}

