/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view;

import edu.colorado.phet.reactionsandrates.DebugFlags;
import edu.colorado.phet.reactionsandrates.model.EnergyProfile;
import edu.colorado.phet.reactionsandrates.model.MoleculeA;
import edu.colorado.phet.reactionsandrates.model.MoleculeC;
import edu.colorado.phet.reactionsandrates.model.Selectable;
import edu.colorado.phet.reactionsandrates.model.SimpleMolecule;
import edu.colorado.phet.reactionsandrates.view.ObservingMoleculeGraphic;
import edu.umd.cs.piccolo.event.PBasicInputEventHandler;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.Color;

public class SpatialSimpleMoleculeGraphic
extends ObservingMoleculeGraphic {
    private PPath boundingBox;
    private final SimpleMolecule molecule;
    private final EnergyProfile profile;

    public SpatialSimpleMoleculeGraphic(SimpleMolecule simpleMolecule, EnergyProfile energyProfile) {
        super(simpleMolecule, energyProfile);
        this.molecule = simpleMolecule;
        this.profile = energyProfile;
        if (simpleMolecule instanceof MoleculeA || simpleMolecule instanceof MoleculeC) {
            this.addInputEventListener(new PBasicInputEventHandler(){

                public void mouseClicked(PInputEvent pInputEvent) {
                    super.mouseClicked(pInputEvent);
                    SpatialSimpleMoleculeGraphic.this.getMolecule().setSelectionStatus(Selectable.SELECTED);
                }
            });
        }
        if (DebugFlags.SHOW_BOUNDING_BOX) {
            this.boundingBox = new PPath();
            this.boundingBox.setStrokePaint(Color.red);
            this.addChild(this.boundingBox);
            this.update();
        }
    }

    public Object clone() {
        return new SpatialSimpleMoleculeGraphic((SimpleMolecule)this.molecule.clone(), this.profile);
    }

    public void update() {
        super.update();
        this.setOffset(this.getMolecule().getCM());
        if (DebugFlags.SHOW_BOUNDING_BOX && this.boundingBox != null) {
            this.boundingBox.setPathTo(this.getMolecule().getBoundingBox());
            this.boundingBox.setOffset(-this.getMolecule().getPosition().getX(), -this.getMolecule().getPosition().getY());
        }
    }
}

