/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.RegisterablePNode;
import edu.colorado.phet.reactionsandrates.model.EnergyProfile;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.model.MoleculeA;
import edu.colorado.phet.reactionsandrates.model.MoleculeAB;
import edu.colorado.phet.reactionsandrates.model.MoleculeBC;
import edu.colorado.phet.reactionsandrates.model.MoleculeC;
import edu.colorado.phet.reactionsandrates.model.reactions.A_BC_AB_C_Reaction;
import edu.colorado.phet.reactionsandrates.model.reactions.Reaction;
import edu.colorado.phet.reactionsandrates.view.icons.MoleculeIcon;
import edu.colorado.phet.reactionsandrates.view.icons.ReactionArrowNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.awt.Insets;
import java.awt.geom.Point2D;

public class ReactionGraphic
extends RegisterablePNode
implements MRModel.ModelListener {
    private PImage aNode = new PImage();
    private PImage cNode = new PImage();
    private PImage abNode = new PImage();
    private PImage bcNode = new PImage();

    public ReactionGraphic(Reaction reaction, Color color, MRModel mRModel) {
        mRModel.addListener(this);
        if (!(reaction instanceof A_BC_AB_C_Reaction)) {
            throw new IllegalArgumentException("Reaction not recognized");
        }
        Insets insets = new Insets(0, 3, 0, 3);
        this.setMoleculeImages(mRModel.getEnergyProfile());
        ReactionArrowNode reactionArrowNode = new ReactionArrowNode(color);
        PhetFont phetFont = new PhetFont(1, 18);
        PText pText = new PText("+");
        pText.setTextPaint(color);
        pText.setFont(phetFont);
        PText pText2 = new PText("+");
        pText2.setFont(phetFont);
        pText2.setTextPaint(color);
        this.aNode.setOffset(0.0, -this.aNode.getFullBounds().getHeight() / 2.0);
        this.setChainedOffset(pText, this.aNode, insets);
        this.setChainedOffset(this.bcNode, pText, insets);
        this.setChainedOffset(reactionArrowNode, this.bcNode, insets);
        this.setChainedOffset(this.abNode, reactionArrowNode, insets);
        this.setChainedOffset(pText2, this.abNode, insets);
        this.setChainedOffset(this.cNode, pText2, insets);
        this.addChild(this.aNode);
        this.addChild(this.cNode);
        this.addChild(this.abNode);
        this.addChild(this.bcNode);
        this.addChild(reactionArrowNode);
        this.addChild(pText);
        this.addChild(pText2);
        this.setRegistrationPoint(this.getFullBounds().getWidth() / 2.0, 0.0);
    }

    private void setChainedOffset(PNode pNode, PNode pNode2, Insets insets) {
        Point2D.Double double_ = new Point2D.Double(pNode2.getOffset().getX() + pNode2.getFullBounds().getWidth() + (double)insets.left + (double)insets.right, -pNode.getFullBounds().getHeight() / 2.0);
        pNode.setOffset(double_);
    }

    private void setMoleculeImages(EnergyProfile energyProfile) {
        this.aNode.setImage(new MoleculeIcon(MoleculeA.class, energyProfile).getImage());
        this.cNode.setImage(new MoleculeIcon(MoleculeC.class, energyProfile).getImage());
        this.abNode.setImage(new MoleculeIcon(MoleculeAB.class, energyProfile).getImage());
        this.bcNode.setImage(new MoleculeIcon(MoleculeBC.class, energyProfile).getImage());
    }

    public void notifyEnergyProfileChanged(EnergyProfile energyProfile) {
        this.setMoleculeImages(energyProfile);
    }

    public void notifyDefaultTemperatureChanged(double d) {
    }
}

