/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.reactionsandrates.model.ProvisionalBond;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;

public class ProvisionalBondGraphic
extends PNode
implements SimpleObserver {
    private static int numColors = 50;
    private static Color[] colors = new Color[numColors];
    private Stroke stroke = new BasicStroke(3.0f);
    private Line2D line;
    private ProvisionalBond bond;
    private PPath linePath;

    public ProvisionalBondGraphic(ProvisionalBond provisionalBond) {
        provisionalBond.addObserver(this);
        this.bond = provisionalBond;
        this.line = new Line2D.Double();
        this.linePath = new PPath(this.line, this.stroke);
        this.linePath.setStrokePaint(Color.red);
        this.addChild(this.linePath);
        this.update();
    }

    public void update() {
        Point2D point2D = this.bond.getMolecules()[0].getPosition();
        Point2D point2D2 = this.bond.getMolecules()[1].getPosition();
        this.line.setLine(point2D, point2D2);
        this.linePath.setPathTo(this.line);
        double d = point2D2.distance(point2D) - this.bond.getMolecules()[0].getRadius() - this.bond.getMolecules()[1].getRadius();
        int n = (int)((double)numColors * (d / this.bond.getMaxBondLength())) - 1;
        n = Math.max(0, Math.min(n, colors.length - 1));
        this.linePath.setStrokePaint(colors[n]);
        if (point2D.distance(point2D2) > 100.0) {
            System.out.println("ProvisionalBondGraphic.update");
        }
    }

    static {
        for (int i = 0; i < colors.length; ++i) {
            ProvisionalBondGraphic.colors[i] = new Color(255, 0, 0, (int)(255.0 * ((double)(colors.length - i) / (double)numColors)));
        }
    }
}

