/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view;

import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.reactionsandrates.MRConfig;
import edu.colorado.phet.reactionsandrates.model.EnergyProfile;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.model.MoleculeA;
import edu.colorado.phet.reactionsandrates.model.MoleculeAB;
import edu.colorado.phet.reactionsandrates.model.MoleculeBC;
import edu.colorado.phet.reactionsandrates.model.MoleculeC;
import edu.colorado.phet.reactionsandrates.util.ControlBorderFactory;
import edu.colorado.phet.reactionsandrates.view.MoleculeCountSpinner;
import edu.colorado.phet.reactionsandrates.view.icons.MoleculeIcon;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MoleculeInstanceControlPanel
extends JPanel {
    private List counters = new ArrayList();
    private JLabel aLabel = new JLabel();
    private JLabel cLabel = new JLabel();
    private JLabel abLabel = new JLabel();
    private JLabel bcLabel = new JLabel();
    private final ClearContainerButton clearContainerButton;

    public MoleculeInstanceControlPanel(final MRModel mRModel, IClock iClock) {
        mRModel.addListener(new MRModel.ModelListenerAdapter(){

            public void notifyEnergyProfileChanged(EnergyProfile energyProfile) {
                MoleculeInstanceControlPanel.this.updateIcons(mRModel.getEnergyProfile());
            }
        });
        this.updateIcons(mRModel.getEnergyProfile());
        MoleculeCountSpinner moleculeCountSpinner = new MoleculeCountSpinner(MoleculeA.class, mRModel, 0, 200);
        this.counters.add(moleculeCountSpinner);
        MoleculeCountSpinner moleculeCountSpinner2 = new MoleculeCountSpinner(MoleculeC.class, mRModel, 0, 200);
        this.counters.add(moleculeCountSpinner2);
        MoleculeCountSpinner moleculeCountSpinner3 = new MoleculeCountSpinner(MoleculeAB.class, mRModel, 0, 200);
        this.counters.add(moleculeCountSpinner3);
        MoleculeCountSpinner moleculeCountSpinner4 = new MoleculeCountSpinner(MoleculeBC.class, mRModel, 0, 200);
        this.counters.add(moleculeCountSpinner4);
        this.setBorder(ControlBorderFactory.createPrimaryBorder(MRConfig.RESOURCES.getLocalizedString("Control.numMolecules")));
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(2, 0, 2, 0);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 0, insets, 0, 0);
        this.add((Component)this.aLabel, gridBagConstraints);
        this.add((Component)this.bcLabel, gridBagConstraints);
        this.add((Component)this.abLabel, gridBagConstraints);
        this.add((Component)this.cLabel, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.anchor = 17;
        this.add((Component)moleculeCountSpinner, gridBagConstraints);
        this.add((Component)moleculeCountSpinner4, gridBagConstraints);
        this.add((Component)moleculeCountSpinner3, gridBagConstraints);
        this.add((Component)moleculeCountSpinner2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 10;
        this.clearContainerButton = new ClearContainerButton(mRModel, iClock);
        this.add((Component)this.clearContainerButton, gridBagConstraints);
    }

    private void updateIcons(EnergyProfile energyProfile) {
        this.aLabel.setIcon(new MoleculeIcon(MoleculeA.class, energyProfile));
        this.cLabel.setIcon(new MoleculeIcon(MoleculeC.class, energyProfile));
        this.abLabel.setIcon(new MoleculeIcon(MoleculeAB.class, energyProfile));
        this.bcLabel.setIcon(new MoleculeIcon(MoleculeBC.class, energyProfile));
    }

    public void setClearContainerButtonVisible(boolean bl) {
        this.clearContainerButton.setVisible(bl);
    }

    public void setCountersEditable(boolean bl) {
        for (int i = 0; i < this.counters.size(); ++i) {
            MoleculeCountSpinner moleculeCountSpinner = (MoleculeCountSpinner)this.counters.get(i);
            moleculeCountSpinner.setEnabled(bl);
        }
    }

    private static class ClearContainerButton
    extends JButton {
        public ClearContainerButton(final MRModel mRModel, final IClock iClock) {
            super(MRConfig.RESOURCES.getLocalizedString("Control.clearContainer"));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    mRModel.removeAllMolecules();
                    iClock.resetSimulationTime();
                }
            });
        }
    }
}

