/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.reactionsandrates.model.AbstractMolecule;
import edu.colorado.phet.reactionsandrates.model.CompositeMolecule;
import edu.colorado.phet.reactionsandrates.model.ConstantTemperatureMoleculeParamGenerator;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.model.MoleculeFactory;
import edu.colorado.phet.reactionsandrates.model.MoleculeParamGenerator;
import edu.colorado.phet.reactionsandrates.model.PublishingModel;
import edu.colorado.phet.reactionsandrates.model.SimpleMolecule;
import edu.colorado.phet.reactionsandrates.view.IntegerRangeSpinner;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MoleculeCountSpinner
extends IntegerRangeSpinner
implements AbstractMolecule.ClassListener,
PublishingModel.ModelListener {
    private Class moleculeClass;
    private MRModel model;
    private int cnt;
    private boolean selfUpdating;
    private MoleculeParamGenerator moleculeParamGenerator;

    public MoleculeCountSpinner(Class clazz, MRModel mRModel, int n, int n2) {
        super(n, n2, true);
        this.moleculeClass = clazz;
        this.model = mRModel;
        mRModel.addListener(this);
        AbstractMolecule.addClassListener(this);
        Rectangle2D rectangle2D = mRModel.getBox().getBounds();
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getMinX() + 20.0, rectangle2D.getMinY() + 20.0, rectangle2D.getWidth() - 40.0, rectangle2D.getHeight() - 40.0);
        this.moleculeParamGenerator = new ConstantTemperatureMoleculeParamGenerator(double_, mRModel, 0.1, 0.0, Math.PI * 2, clazz);
        this.setValue(new Integer(n));
        this.addChangeListener(new SpinnerChangeListener(clazz, mRModel));
    }

    private void addMoleculeToModel(AbstractMolecule abstractMolecule, MRModel mRModel) {
        mRModel.addModelElement(abstractMolecule);
        if (abstractMolecule instanceof CompositeMolecule) {
            SimpleMolecule[] simpleMoleculeArray = abstractMolecule.getComponentMolecules();
            for (int i = 0; i < simpleMoleculeArray.length; ++i) {
                SimpleMolecule simpleMolecule = simpleMoleculeArray[i];
                mRModel.addModelElement(simpleMolecule);
            }
        }
    }

    private void removeMoleculeFromModel(AbstractMolecule abstractMolecule, MRModel mRModel) {
        mRModel.removeModelElement(abstractMolecule);
        if (abstractMolecule instanceof CompositeMolecule) {
            SimpleMolecule[] simpleMoleculeArray = abstractMolecule.getComponentMolecules();
            for (int i = 0; i < simpleMoleculeArray.length; ++i) {
                SimpleMolecule simpleMolecule = simpleMoleculeArray[i];
                mRModel.removeModelElement(simpleMolecule);
            }
        }
    }

    private void setMoleculeCount() {
        ArrayList arrayList = this.model.getModelElements();
        int n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (!this.moleculeClass.isInstance(e) || ((AbstractMolecule)e).isPartOfComposite()) continue;
            ++n;
        }
        this.cnt = n;
        this.setValue(new Integer(n));
    }

    public void statusChanged(AbstractMolecule abstractMolecule) {
        this.setMoleculeCount();
    }

    public void modelElementAdded(ModelElement modelElement) {
        if (!this.selfUpdating && this.moleculeClass.isInstance(modelElement)) {
            this.setMoleculeCount();
        }
    }

    public void modelElementRemoved(ModelElement modelElement) {
        if (!this.selfUpdating && this.moleculeClass.isInstance(modelElement)) {
            this.setMoleculeCount();
        }
    }

    public void endOfTimeStep(PublishingModel publishingModel, ClockEvent clockEvent) {
    }

    private class SpinnerChangeListener
    implements ChangeListener {
        private final Class moleculeClass;
        private final MRModel model;

        public SpinnerChangeListener(Class clazz, MRModel mRModel) {
            this.moleculeClass = clazz;
            this.model = mRModel;
        }

        public void stateChanged(ChangeEvent changeEvent) {
            MoleculeCountSpinner.this.selfUpdating = true;
            final int n = (Integer)MoleculeCountSpinner.this.getValue() - MoleculeCountSpinner.this.cnt;
            for (int i = 0; i < Math.abs(n); ++i) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (n > 0) {
                            AbstractMolecule abstractMolecule = MoleculeFactory.createMolecule(SpinnerChangeListener.this.moleculeClass, MoleculeCountSpinner.this.moleculeParamGenerator);
                            MoleculeCountSpinner.this.addMoleculeToModel(abstractMolecule, SpinnerChangeListener.this.model);
                        } else if (n < 0) {
                            ArrayList arrayList = SpinnerChangeListener.this.model.getModelElements();
                            for (int i = arrayList.size() - 1; i >= 0; --i) {
                                Object e = arrayList.get(i);
                                if (!SpinnerChangeListener.this.moleculeClass.isInstance(e) || ((AbstractMolecule)e).isPartOfComposite()) continue;
                                AbstractMolecule abstractMolecule = (AbstractMolecule)e;
                                MoleculeCountSpinner.this.removeMoleculeFromModel(abstractMolecule, SpinnerChangeListener.this.model);
                                break;
                            }
                            MoleculeCountSpinner.this.setMoleculeCount();
                        }
                    }
                });
            }
            MoleculeCountSpinner.this.selfUpdating = false;
        }
    }
}

