/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view;

import edu.colorado.phet.reactionsandrates.MRConfig;
import edu.colorado.phet.reactionsandrates.model.EnergyProfile;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.model.MoleculeA;
import edu.colorado.phet.reactionsandrates.model.MoleculeC;
import edu.colorado.phet.reactionsandrates.model.SimpleMolecule;
import edu.colorado.phet.reactionsandrates.modules.SimpleModule;
import edu.colorado.phet.reactionsandrates.util.ControlBorderFactory;
import edu.colorado.phet.reactionsandrates.view.icons.MoleculeIcon;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class LauncherLoadPanel
extends JPanel {
    private JRadioButton aRB;
    private JRadioButton cRB;
    private SimpleModule module;
    private JLabel moleculeCLabel;
    private JLabel moleculeALabel;

    public LauncherLoadPanel(SimpleModule simpleModule) {
        this.module = simpleModule;
        this.moleculeALabel = new JLabel();
        this.moleculeALabel.setHorizontalAlignment(0);
        this.moleculeCLabel = new JLabel();
        this.moleculeCLabel.setHorizontalAlignment(0);
        simpleModule.getMRModel().addListener(new MRModel.ModelListenerAdapter(){

            public void notifyEnergyProfileChanged(EnergyProfile energyProfile) {
                LauncherLoadPanel.this.updateIcons();
            }
        });
        this.updateIcons();
        this.setBorder(ControlBorderFactory.createPrimaryBorder(MRConfig.RESOURCES.getLocalizedString("Control.launch-type")));
        this.setBackground(MRConfig.SPATIAL_VIEW_BACKGROUND);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.aRB = new JRadioButton();
        this.cRB = new JRadioButton();
        buttonGroup.add(this.aRB);
        buttonGroup.add(this.cRB);
        this.aRB.addActionListener(new MoleculeSelectorRBAction());
        this.cRB.addActionListener(new MoleculeSelectorRBAction());
        this.aRB.setBackground(MRConfig.SPATIAL_VIEW_BACKGROUND);
        this.cRB.setBackground(MRConfig.SPATIAL_VIEW_BACKGROUND);
        this.setLayout(new GridBagLayout());
        int n = 10;
        int n2 = 10;
        Insets insets = new Insets(3, 25, 3, 5);
        Insets insets2 = new Insets(3, 5, 3, 25);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, n, 2, insets, 0, 0);
        this.add((Component)this.aRB, gridBagConstraints);
        this.add((Component)this.cRB, gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridy = -1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = n2;
        gridBagConstraints.insets = insets2;
        this.add((Component)this.moleculeALabel, gridBagConstraints);
        this.add((Component)this.moleculeCLabel, gridBagConstraints);
        gridBagConstraints.gridwidth = 2;
        this.add(Box.createHorizontalStrut(30), gridBagConstraints);
        this.cRB.setSelected(true);
    }

    private void updateIcons() {
        this.moleculeALabel.setIcon(new MoleculeIcon(MoleculeA.class, this.module.getMRModel().getEnergyProfile()));
        this.moleculeCLabel.setIcon(new MoleculeIcon(MoleculeC.class, this.module.getMRModel().getEnergyProfile()));
    }

    public void setMolecule(SimpleMolecule simpleMolecule) {
        this.aRB.setSelected(simpleMolecule instanceof MoleculeA);
        this.cRB.setSelected(simpleMolecule instanceof MoleculeC);
    }

    private class MoleculeSelectorRBAction
    extends AbstractAction {
        private MoleculeSelectorRBAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (LauncherLoadPanel.this.aRB.isSelected()) {
                LauncherLoadPanel.this.module.setMolecules(LauncherLoadPanel.this.module.getMRModel(), new MoleculeA());
            }
            if (LauncherLoadPanel.this.cRB.isSelected()) {
                LauncherLoadPanel.this.module.setMolecules(LauncherLoadPanel.this.module.getMRModel(), new MoleculeC());
            }
        }
    }
}

