/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view;

import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.reactionsandrates.MRConfig;
import java.awt.Toolkit;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.text.ParseException;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;

public class IntegerRangeSpinner
extends JSpinner {
    private final JFormattedTextField textField;
    private final int min;
    private final int max;
    private final boolean showInvalidValueDialog;

    public IntegerRangeSpinner(int n, int n2) {
        this(n, n2, true);
    }

    public IntegerRangeSpinner(int n, int n2, boolean bl) {
        this.min = n;
        this.max = n2;
        this.showInvalidValueDialog = bl;
        this.setModel(new SpinnerNumberModel(0, n, n2, 1));
        JSpinner.NumberEditor numberEditor = new JSpinner.NumberEditor(this);
        this.setEditor(numberEditor);
        this.textField = numberEditor.getTextField();
        this.textField.setColumns(3);
        this.textField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    IntegerRangeSpinner.this.commit();
                }
            }
        });
        this.textField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                IntegerRangeSpinner.this.commit();
            }

            public void focusGained(FocusEvent focusEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        IntegerRangeSpinner.this.textField.selectAll();
                    }
                });
            }
        });
    }

    public void setIntValue(int n) {
        this.setValue(new Integer(n));
    }

    public int getIntValue() {
        return (Integer)this.getValue();
    }

    private void commit() {
        block2: {
            try {
                this.commitEdit();
            }
            catch (ParseException parseException) {
                Toolkit.getDefaultToolkit().beep();
                this.textField.setValue(this.getValue());
                this.textField.selectAll();
                if (!this.showInvalidValueDialog) break block2;
                this.showInvalidValueDialog();
            }
        }
    }

    private void showInvalidValueDialog() {
        String string = MRConfig.RESOURCES.getLocalizedString("messages.invalidValue");
        Object[] objectArray = new Object[]{new Integer(this.min), new Integer(this.max)};
        String string2 = MessageFormat.format(string, objectArray);
        PhetOptionPane.showErrorDialog(this, string2);
    }
}

