/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.view;

import edu.colorado.phet.common.collision.Box2D;
import edu.colorado.phet.common.piccolophet.nodes.RegisterablePNode;
import edu.colorado.phet.common.piccolophet.util.PImageFactory;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import java.awt.BasicStroke;
import java.awt.Dimension;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;

public class BoxGraphic
extends RegisterablePNode {
    private boolean glassBox = true;
    private float wallThickness = 15.0f;
    private Stroke stroke = new BasicStroke(this.wallThickness);

    public BoxGraphic(Box2D box2D) {
        if (this.glassBox) {
            Dimension dimension = new Dimension((int)(box2D.getWidth() + (double)(2.0f * this.wallThickness)), (int)(box2D.getHeight() + (double)(2.0f * this.wallThickness)));
            PImage pImage = PImageFactory.create("reactions-and-rates/images/glass-box-B.png", dimension);
            this.addChild(pImage);
            this.setRegistrationPoint(this.wallThickness, this.wallThickness);
            this.setPickable(false);
            this.setChildrenPickable(false);
        } else {
            Rectangle2D.Double double_ = new Rectangle2D.Double(0.0, 0.0, box2D.getWidth() + (double)this.wallThickness, box2D.getHeight() + (double)this.wallThickness);
            PPath pPath = new PPath(double_, this.stroke);
            this.addChild(pPath);
            this.setOffset(box2D.getMinX() - (double)(this.wallThickness / 2.0f), box2D.getMinY() - (double)(this.wallThickness / 2.0f));
        }
    }
}

