/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.util;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.reactionsandrates.model.PublishingModel;
import edu.umd.cs.piccolo.PNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ModelElementGraphicManager
extends PublishingModel.ModelListenerAdapter {
    private Map modelElementClassToGraphicFactory = new HashMap();
    private PNode canvas;
    private HashMap modelElementToGraphicMap = new HashMap();
    private Set invisibleGraphicClasses = new HashSet();
    private PNode moleculeLayer = new PNode();
    private PNode boxLayer = new PNode();
    private PublishingModel model;

    public ModelElementGraphicManager(PublishingModel publishingModel, PNode pNode) {
        this.canvas = pNode;
        this.model = publishingModel;
        publishingModel.addListener(this);
        pNode.addChild(this.moleculeLayer);
        pNode.addChild(this.boxLayer);
    }

    public void addGraphicFactory(GraphicFactory graphicFactory) {
        this.modelElementClassToGraphicFactory.put(graphicFactory.getModelElementClass(), graphicFactory);
    }

    public void scanModel() {
        ArrayList arrayList = this.model.getModelElements();
        for (int i = 0; i < arrayList.size(); ++i) {
            ModelElement modelElement = (ModelElement)arrayList.get(i);
            if (this.modelElementToGraphicMap.get(modelElement) != null) continue;
            this.modelElementAdded(modelElement);
        }
    }

    public void modelElementAdded(ModelElement modelElement) {
        PNode pNode = null;
        PNode pNode2 = this.canvas;
        GraphicFactory graphicFactory = null;
        for (Class<?> clazz = modelElement.getClass(); clazz != Object.class && graphicFactory == null; clazz = clazz.getSuperclass()) {
            graphicFactory = (GraphicFactory)this.modelElementClassToGraphicFactory.get(clazz);
        }
        if (graphicFactory != null) {
            pNode = graphicFactory.createGraphic(modelElement);
            pNode2 = graphicFactory.getLayer() != null ? graphicFactory.getLayer() : this.canvas;
            if (this.invisibleGraphicClasses.contains(pNode.getClass())) {
                pNode.setVisible(false);
            }
            this.modelElementToGraphicMap.put(modelElement, new GraphicRecord(pNode, pNode2));
            this.addGraphic(pNode, pNode2);
        }
    }

    public void modelElementRemoved(ModelElement modelElement) {
        GraphicRecord graphicRecord = (GraphicRecord)this.modelElementToGraphicMap.get(modelElement);
        if (graphicRecord != null) {
            PNode pNode = graphicRecord.getLayer();
            PNode pNode2 = graphicRecord.getGraphic();
            pNode.removeChild(pNode2);
            this.modelElementToGraphicMap.remove(modelElement);
        }
    }

    public void addGraphic(PNode pNode, PNode pNode2) {
        pNode2.addChild(pNode);
    }

    public void setAllOfTypeVisible(Class clazz, boolean bl) {
        for (GraphicRecord graphicRecord : this.modelElementToGraphicMap.values()) {
            if (!clazz.isInstance(graphicRecord.getGraphic())) continue;
            PNode pNode = graphicRecord.getGraphic();
            pNode.setVisible(bl);
        }
        if (!bl) {
            this.invisibleGraphicClasses.add(clazz);
        } else {
            this.invisibleGraphicClasses.remove(clazz);
        }
    }

    public List getGraphicsForModelElementClass(Class clazz) {
        ArrayList<PNode> arrayList = new ArrayList<PNode>();
        for (ModelElement modelElement : this.modelElementToGraphicMap.keySet()) {
            if (!clazz.isInstance(modelElement)) continue;
            GraphicRecord graphicRecord = (GraphicRecord)this.modelElementToGraphicMap.get(modelElement);
            arrayList.add(graphicRecord.getGraphic());
        }
        return arrayList;
    }

    public static abstract class GraphicFactory {
        private Class modelElementClass;
        private PNode layer;

        protected GraphicFactory(Class clazz, PNode pNode) {
            this.modelElementClass = clazz;
            this.layer = pNode;
        }

        public Class getModelElementClass() {
            return this.modelElementClass;
        }

        public PNode getLayer() {
            return this.layer;
        }

        public abstract PNode createGraphic(ModelElement var1);
    }

    private static class GraphicRecord {
        private PNode graphic;
        private PNode layer;

        public GraphicRecord(PNode pNode, PNode pNode2) {
            this.graphic = pNode;
            this.layer = pNode2;
        }

        public PNode getGraphic() {
            return this.graphic;
        }

        public PNode getLayer() {
            return this.layer;
        }
    }
}

