/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.modules;

import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.view.ResetAllButton;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.modules.MRControlPanel;
import edu.colorado.phet.reactionsandrates.modules.RateExperimentsModule;
import edu.colorado.phet.reactionsandrates.view.ExperimentSetupPanel;
import edu.colorado.phet.reactionsandrates.view.MoleculeInstanceControlPanel;
import edu.colorado.phet.reactionsandrates.view.charts.ChartOptionsPanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;

public class RateExperimentsMRControlPanel
extends MRControlPanel {
    private MoleculeInstanceControlPanel moleculeInstanceControlPanel;
    private ChartOptionsPanel optionsPanel;
    public ExperimentSetupPanel experimentSetupPanel;

    public RateExperimentsMRControlPanel(final RateExperimentsModule rateExperimentsModule) {
        super(new GridBagLayout());
        MRModel mRModel = (MRModel)rateExperimentsModule.getModel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 11, 0, new Insets(5, 0, 0, 0), 0, 0);
        this.experimentSetupPanel = new ExperimentSetupPanel(rateExperimentsModule);
        this.moleculeInstanceControlPanel = new MoleculeInstanceControlPanel(mRModel, rateExperimentsModule.getClock());
        this.moleculeInstanceControlPanel.setClearContainerButtonVisible(false);
        this.optionsPanel = new ChartOptionsPanel(rateExperimentsModule);
        ResetAllButton resetAllButton = new ResetAllButton(this);
        resetAllButton.addResettable(new Resettable(){

            public void reset() {
                rateExperimentsModule.reset();
            }
        });
        gridBagConstraints.fill = 2;
        this.add((Component)this.experimentSetupPanel, gridBagConstraints);
        this.add((Component)this.moleculeInstanceControlPanel, gridBagConstraints);
        this.add((Component)this.optionsPanel, gridBagConstraints);
        gridBagConstraints.fill = 0;
        this.add((Component)resetAllButton, gridBagConstraints);
        this.reset();
    }

    public MoleculeInstanceControlPanel getMoleculeInstanceControlPanel() {
        return this.moleculeInstanceControlPanel;
    }

    public void reset() {
        this.experimentSetupPanel.reset();
        this.optionsPanel.reset();
        this.setExperimentRunning(false);
    }

    public void clearExperiment() {
        this.experimentSetupPanel.endExperiment();
    }

    public void setExperimentRunning(boolean bl) {
        this.getMoleculeInstanceControlPanel().setCountersEditable(bl);
    }

    public boolean isTemperatureBeingAdjusted() {
        boolean bl = super.isTemperatureBeingAdjusted();
        if (!bl) {
            bl = this.experimentSetupPanel.isTemperatureBeingAdjusted();
        }
        return bl;
    }
}

