/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.modules;

import edu.colorado.phet.common.phetcommon.application.Module;
import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.SwingClock;
import edu.colorado.phet.common.phetcommon.model.clock.VariableConstantTickClock;
import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.reactionsandrates.MRConfig;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.view.SpatialView;
import edu.colorado.phet.reactionsandrates.view.energy.EnergyView;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.Timer;
import java.util.TimerTask;

public abstract class MRModule
extends Module {
    private final Dimension canvasSize = MRConfig.SIMULATION_PANEL_SIZE;
    private final SpatialView spatialView;
    private final EnergyView energyView = new EnergyView();
    private final Dimension spatialViewSize = MRConfig.SPATIAL_VIEW_SIZE;
    private final MRModel mrModel;
    private final PhetPCanvas canvas;
    private final Insets simulationPaneInsets;
    private final int chartPaneHeight;
    private volatile boolean resetInProgress;

    public PhetPCanvas getCanvas() {
        return this.canvas;
    }

    public MRModule(String string, Dimension dimension) {
        super(string, new VariableConstantTickClock(new SwingClock(1000 / MRConfig.CLOCK_FPS, 1.0), 1.0));
        this.initiateReset();
        this.chartPaneHeight = dimension.height;
        this.mrModel = new MRModel(this.getClock());
        this.setModel(this.mrModel);
        ControlPanel controlPanel = new ControlPanel();
        controlPanel.getContentPanel().setFillNone();
        this.setControlPanel(controlPanel);
        this.canvas = new PhetPCanvas(this.canvasSize);
        this.setSimulationPanel(this.canvas);
        this.simulationPaneInsets = new Insets(10, 10, 10, 10);
        this.spatialView = new SpatialView(this, this.spatialViewSize);
        this.spatialView.setOffset(this.simulationPaneInsets.left, this.simulationPaneInsets.top);
        this.canvas.addWorldChild(this.spatialView);
        this.getClock().addClockListener(new ClockAdapter(){

            public void clockStarted(ClockEvent clockEvent) {
                ((VariableConstantTickClock)MRModule.this.getClock()).setDt(1.0);
            }

            public void clockPaused(ClockEvent clockEvent) {
                ((VariableConstantTickClock)MRModule.this.getClock()).setDt(0.3);
            }
        });
        this.createEnergyView(dimension);
        this.completeReset();
    }

    public boolean isTemperatureBeingAdjusted() {
        return this.spatialView.isTemperatureBeingAdjusted();
    }

    public boolean isResetInProgress() {
        return this.resetInProgress;
    }

    private void createEnergyView(Dimension dimension) {
        this.energyView.initialize(this, dimension);
        this.energyView.setOffset((double)this.simulationPaneInsets.left + this.spatialView.getFullBounds().getWidth() + (double)this.simulationPaneInsets.left, this.simulationPaneInsets.top);
        this.canvas.addWorldChild(this.energyView);
    }

    public void clearExperiment() {
        this.getMRModel().removeAllMolecules();
    }

    public void reset() {
        this.initiateReset();
        this.clearExperiment();
        ((MRModel)this.getModel()).setInitialConditions();
        this.energyView.reset();
        this.getClock().start();
        this.completeReset();
    }

    protected SpatialView getSpatialView() {
        return this.spatialView;
    }

    public EnergyView getEnergyView() {
        return this.energyView;
    }

    public MRModel getMRModel() {
        return (MRModel)this.getModel();
    }

    public void setGraphicTypeVisible(boolean bl) {
        this.spatialView.setGraphicTypeVisible(bl);
    }

    protected void initiateReset() {
        this.resetInProgress = true;
    }

    protected void completeReset() {
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            public void run() {
                MRModule.this.resetInProgress = false;
            }
        }, 1000L);
    }
}

