/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.model.reactions;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.reactionsandrates.MRConfig;
import edu.colorado.phet.reactionsandrates.model.AbstractMolecule;
import edu.colorado.phet.reactionsandrates.model.CollisionParams;
import edu.colorado.phet.reactionsandrates.model.CompositeMolecule;
import edu.colorado.phet.reactionsandrates.model.EnergyProfile;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.model.MoleculeA;
import edu.colorado.phet.reactionsandrates.model.MoleculeAB;
import edu.colorado.phet.reactionsandrates.model.MoleculeB;
import edu.colorado.phet.reactionsandrates.model.MoleculeBC;
import edu.colorado.phet.reactionsandrates.model.MoleculeC;
import edu.colorado.phet.reactionsandrates.model.MoleculeFactory;
import edu.colorado.phet.reactionsandrates.model.SimpleMolecule;
import edu.colorado.phet.reactionsandrates.model.collision.HardBodyCollision;
import edu.colorado.phet.reactionsandrates.model.reactions.Reaction;

public class A_BC_AB_C_Reaction
extends Reaction {
    private static EnergyProfile energyProfile = MRConfig.DEFAULT_ENERGY_PROFILE;
    private MRModel model;

    public A_BC_AB_C_Reaction(MRModel mRModel) {
        super(energyProfile, new Criteria(energyProfile));
        this.model = mRModel;
    }

    public double getPotentialEnergy(AbstractMolecule abstractMolecule, AbstractMolecule abstractMolecule2) {
        double d = 0.0;
        if (abstractMolecule instanceof MoleculeAB || abstractMolecule2 instanceof MoleculeAB) {
            d = this.getEnergyProfile().getRightLevel();
        } else if (abstractMolecule instanceof MoleculeBC || abstractMolecule2 instanceof MoleculeBC) {
            d = this.getEnergyProfile().getLeftLevel();
        } else {
            throw new RuntimeException("internal error");
        }
        return d;
    }

    public void doReaction(CompositeMolecule compositeMolecule, SimpleMolecule simpleMolecule) {
        double d = this.getPotentialEnergy(compositeMolecule, simpleMolecule);
        double d2 = compositeMolecule.getKineticEnergy() + simpleMolecule.getKineticEnergy();
        MoleculeB moleculeB = compositeMolecule.getComponentMolecules()[0] instanceof MoleculeB ? (MoleculeB)compositeMolecule.getComponentMolecules()[0] : (MoleculeB)compositeMolecule.getComponentMolecules()[1];
        SimpleMolecule simpleMolecule2 = compositeMolecule.getComponentMolecules()[0] instanceof MoleculeB ? compositeMolecule.getComponentMolecules()[1] : compositeMolecule.getComponentMolecules()[0];
        HardBodyCollision hardBodyCollision = new HardBodyCollision();
        hardBodyCollision.detectAndDoCollision(simpleMolecule, moleculeB);
        hardBodyCollision.detectAndDoCollision(moleculeB, simpleMolecule2);
        this.model.removeModelElement(compositeMolecule);
        compositeMolecule.getComponentMolecules()[0].setParentComposite(null);
        compositeMolecule.getComponentMolecules()[1].setParentComposite(null);
        compositeMolecule.removeSimpleMolecule(compositeMolecule.getComponentMolecules()[0]);
        compositeMolecule.removeSimpleMolecule(compositeMolecule.getComponentMolecules()[0]);
        AbstractMolecule abstractMolecule = null;
        if (simpleMolecule instanceof MoleculeA) {
            abstractMolecule = new MoleculeAB(new SimpleMolecule[]{simpleMolecule, moleculeB});
        } else if (simpleMolecule instanceof MoleculeC) {
            abstractMolecule = new MoleculeBC(new SimpleMolecule[]{simpleMolecule, moleculeB});
        }
        simpleMolecule.setVelocity(abstractMolecule.getVelocity());
        moleculeB.setVelocity(abstractMolecule.getVelocity());
        MutableVector2D mutableVector2D = new MutableVector2D(((CompositeMolecule)abstractMolecule).getCM(), moleculeB.getPosition());
        MutableVector2D mutableVector2D2 = new MutableVector2D(((CompositeMolecule)abstractMolecule).getCM(), simpleMolecule.getPosition());
        double d3 = moleculeB.getPosition().distance(simpleMolecule.getPosition());
        double d4 = MoleculeFactory.getComponentMoleculesOffset(simpleMolecule, moleculeB) / d3;
        moleculeB.setPosition(((CompositeMolecule)abstractMolecule).getCM().getX() + mutableVector2D.getX() * d4, ((CompositeMolecule)abstractMolecule).getCM().getY() + mutableVector2D.getY() * d4);
        simpleMolecule.setPosition(((CompositeMolecule)abstractMolecule).getCM().getX() + mutableVector2D2.getX() * d4, ((CompositeMolecule)abstractMolecule).getCM().getY() + mutableVector2D2.getY() * d4);
        this.model.addModelElement(abstractMolecule);
        MutableVector2D mutableVector2D3 = new MutableVector2D(moleculeB.getPosition(), simpleMolecule2.getPosition()).scale(1.5);
        simpleMolecule2.setPosition(moleculeB.getPosition().getX() + mutableVector2D3.getX(), moleculeB.getPosition().getY() + mutableVector2D3.getY());
        double d5 = this.getPotentialEnergy(abstractMolecule, simpleMolecule2);
        double d6 = abstractMolecule.getKineticEnergy() + simpleMolecule2.getKineticEnergy();
        double d7 = d + d2 - (d5 + d6);
        double d8 = Math.sqrt(abstractMolecule.getVelocity().magnitudeSquared() + d7 / abstractMolecule.getMass());
        double d9 = Math.sqrt(simpleMolecule2.getVelocity().magnitudeSquared() + d7 / simpleMolecule2.getMass());
    }

    public static double getReactionOffset(AbstractMolecule abstractMolecule, AbstractMolecule abstractMolecule2) {
        double d = Double.POSITIVE_INFINITY;
        if (A_BC_AB_C_Reaction.moleculesAreProperTypes(abstractMolecule, abstractMolecule2)) {
            CollisionParams collisionParams = new CollisionParams(abstractMolecule, abstractMolecule2);
            d = Math.max(collisionParams.getFreeMolecule().getRadius(), collisionParams.getbMolecule().getRadius());
        }
        return d;
    }

    public double getDistanceToCollision(AbstractMolecule abstractMolecule, AbstractMolecule abstractMolecule2) {
        if (A_BC_AB_C_Reaction.moleculesAreProperTypes(abstractMolecule, abstractMolecule2)) {
            SimpleMolecule simpleMolecule;
            double d = this.getCollisionVector(abstractMolecule, abstractMolecule2).magnitude();
            CompositeMolecule compositeMolecule = abstractMolecule instanceof CompositeMolecule ? (CompositeMolecule)abstractMolecule : (CompositeMolecule)abstractMolecule2;
            SimpleMolecule simpleMolecule2 = abstractMolecule2 instanceof CompositeMolecule ? (SimpleMolecule)abstractMolecule : (SimpleMolecule)abstractMolecule2;
            SimpleMolecule simpleMolecule3 = simpleMolecule = compositeMolecule.getComponentMolecules()[0] instanceof MoleculeB ? compositeMolecule.getComponentMolecules()[0] : compositeMolecule.getComponentMolecules()[1];
            if (simpleMolecule2.getPosition().distanceSq(simpleMolecule.getPosition()) < (simpleMolecule2.getRadius() + simpleMolecule.getRadius()) * (simpleMolecule2.getRadius() + simpleMolecule.getRadius())) {
                d = -d;
            }
            return d;
        }
        return Double.POSITIVE_INFINITY;
    }

    public MutableVector2D getCollisionVector(AbstractMolecule abstractMolecule, AbstractMolecule abstractMolecule2) {
        MutableVector2D mutableVector2D = null;
        if (A_BC_AB_C_Reaction.moleculesAreProperTypes(abstractMolecule, abstractMolecule2)) {
            CompositeMolecule compositeMolecule = abstractMolecule instanceof CompositeMolecule ? (CompositeMolecule)abstractMolecule : (CompositeMolecule)abstractMolecule2;
            SimpleMolecule simpleMolecule = abstractMolecule2 instanceof CompositeMolecule ? (SimpleMolecule)abstractMolecule : (SimpleMolecule)abstractMolecule2;
            SimpleMolecule simpleMolecule2 = compositeMolecule.getComponentMolecules()[0] instanceof MoleculeB ? compositeMolecule.getComponentMolecules()[0] : compositeMolecule.getComponentMolecules()[1];
            double d = simpleMolecule2.getPosition().getX() - simpleMolecule.getPosition().getX();
            double d2 = simpleMolecule2.getPosition().getY() - simpleMolecule.getPosition().getY();
            double d3 = Math.atan2(d2, d);
            int n = abstractMolecule == compositeMolecule ? -1 : 1;
            mutableVector2D = new MutableVector2D((double)n * (d -= Math.cos(d3) * (simpleMolecule2.getRadius() + simpleMolecule.getRadius())), (double)n * (d2 -= Math.sin(d3) * (simpleMolecule2.getRadius() + simpleMolecule.getRadius())));
        }
        return mutableVector2D;
    }

    private static class Criteria
    implements Reaction.ReactionCriteria {
        private EnergyProfile energyProfile;

        public Criteria(EnergyProfile energyProfile) {
            this.energyProfile = energyProfile;
        }

        public boolean moleculesAreProperTypes(AbstractMolecule abstractMolecule, AbstractMolecule abstractMolecule2) {
            boolean bl = false;
            CompositeMolecule compositeMolecule = null;
            SimpleMolecule simpleMolecule = null;
            if (abstractMolecule instanceof CompositeMolecule) {
                compositeMolecule = (CompositeMolecule)abstractMolecule;
                if (abstractMolecule2 instanceof SimpleMolecule) {
                    simpleMolecule = (SimpleMolecule)abstractMolecule2;
                    bl = true;
                }
            } else {
                simpleMolecule = (SimpleMolecule)abstractMolecule;
                if (abstractMolecule2 instanceof CompositeMolecule) {
                    compositeMolecule = (CompositeMolecule)abstractMolecule2;
                    bl = true;
                }
            }
            boolean bl2 = false;
            if (bl) {
                if (compositeMolecule instanceof MoleculeAB && simpleMolecule instanceof MoleculeC) {
                    bl2 = true;
                } else if (compositeMolecule instanceof MoleculeBC && simpleMolecule instanceof MoleculeA) {
                    bl2 = true;
                }
            }
            return bl2;
        }
    }
}

