/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.model.collision;

import edu.colorado.phet.common.mechanics.Body;
import edu.colorado.phet.common.mechanics.Vector3D;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.reactionsandrates.model.AbstractMolecule;
import edu.colorado.phet.reactionsandrates.model.CompositeMolecule;
import edu.colorado.phet.reactionsandrates.model.EnergyProfile;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.model.MRModelUtil;
import edu.colorado.phet.reactionsandrates.model.MoleculeA;
import edu.colorado.phet.reactionsandrates.model.MoleculeAB;
import edu.colorado.phet.reactionsandrates.model.MoleculeC;
import edu.colorado.phet.reactionsandrates.model.SimpleMolecule;
import edu.colorado.phet.reactionsandrates.model.collision.MRCollisionAgent;
import edu.colorado.phet.reactionsandrates.model.collision.MoleculeMoleculeCollisionSpec;
import edu.colorado.phet.reactionsandrates.model.reactions.A_BC_AB_C_Reaction;
import edu.colorado.phet.reactionsandrates.model.reactions.Reaction;
import java.awt.geom.Point2D;

public class MoleculeMoleculeCollisionAgent_2
implements MRCollisionAgent {
    private MutableVector2D n = new MutableVector2D();
    private MutableVector2D vRel = new MutableVector2D();
    private MutableVector2D vAng1 = new MutableVector2D();
    private MutableVector2D vAng2 = new MutableVector2D();
    private MutableVector2D angRel = new MutableVector2D();
    private MutableVector2D loa = new MutableVector2D();
    private Reaction.ReactionCriteria reactionCriteria;

    public MoleculeMoleculeCollisionAgent_2(MRModel mRModel) {
        mRModel.getReaction();
        this.reactionCriteria = Reaction.getReactionCriteria();
    }

    public boolean detectAndDoCollision(MRModel mRModel, Body body, Body body2) {
        AbstractMolecule abstractMolecule = (AbstractMolecule)body;
        AbstractMolecule abstractMolecule2 = (AbstractMolecule)body2;
        MoleculeMoleculeCollisionSpec moleculeMoleculeCollisionSpec = null;
        boolean bl = false;
        bl = abstractMolecule.getBoundingBox().intersects(abstractMolecule2.getBoundingBox());
        if (bl && !abstractMolecule.isPartOfComposite() && !abstractMolecule2.isPartOfComposite() && (moleculeMoleculeCollisionSpec = this.getCollisionSpec(abstractMolecule, abstractMolecule2)) != null) {
            this.doCollision(mRModel, abstractMolecule, abstractMolecule2, moleculeMoleculeCollisionSpec);
        }
        return moleculeMoleculeCollisionSpec != null;
    }

    private MoleculeMoleculeCollisionSpec getCollisionSpec(AbstractMolecule abstractMolecule, AbstractMolecule abstractMolecule2) {
        MoleculeMoleculeCollisionSpec moleculeMoleculeCollisionSpec = null;
        if (abstractMolecule instanceof SimpleMolecule && abstractMolecule2 instanceof SimpleMolecule) {
            SimpleMolecule simpleMolecule = (SimpleMolecule)abstractMolecule;
            SimpleMolecule simpleMolecule2 = (SimpleMolecule)abstractMolecule2;
            if (simpleMolecule.getPosition().distanceSq(simpleMolecule2.getPosition()) <= (simpleMolecule.getRadius() + simpleMolecule2.getRadius()) * (simpleMolecule.getRadius() + simpleMolecule2.getRadius())) {
                double d = simpleMolecule.getCM().getX() - simpleMolecule2.getCM().getX();
                double d2 = simpleMolecule.getCM().getY() - simpleMolecule2.getCM().getY();
                double d3 = simpleMolecule.getRadius() / (simpleMolecule.getRadius() + simpleMolecule2.getRadius());
                Point2D.Double double_ = new Point2D.Double(simpleMolecule.getCM().getX() - d * d3, simpleMolecule.getCM().getY() - d2 * d3);
                this.loa.setComponents(d, d2);
                moleculeMoleculeCollisionSpec = new MoleculeMoleculeCollisionSpec(this.loa, double_, (SimpleMolecule)abstractMolecule, (SimpleMolecule)abstractMolecule2);
            }
        } else {
            if (abstractMolecule instanceof CompositeMolecule) {
                CompositeMolecule compositeMolecule = (CompositeMolecule)abstractMolecule;
                MoleculeMoleculeCollisionSpec moleculeMoleculeCollisionSpec2 = null;
                for (int i = 0; i < compositeMolecule.getComponentMolecules().length && moleculeMoleculeCollisionSpec2 == null; ++i) {
                    SimpleMolecule simpleMolecule = compositeMolecule.getComponentMolecules()[i];
                    moleculeMoleculeCollisionSpec2 = this.getCollisionSpec(simpleMolecule, abstractMolecule2);
                }
                return moleculeMoleculeCollisionSpec2;
            }
            if (abstractMolecule2 instanceof CompositeMolecule) {
                CompositeMolecule compositeMolecule = (CompositeMolecule)abstractMolecule2;
                MoleculeMoleculeCollisionSpec moleculeMoleculeCollisionSpec3 = null;
                for (int i = 0; i < compositeMolecule.getComponentMolecules().length && moleculeMoleculeCollisionSpec3 == null; ++i) {
                    SimpleMolecule simpleMolecule = compositeMolecule.getComponentMolecules()[i];
                    moleculeMoleculeCollisionSpec3 = this.getCollisionSpec(abstractMolecule, simpleMolecule);
                }
                return moleculeMoleculeCollisionSpec3;
            }
            throw new RuntimeException("error in function");
        }
        return moleculeMoleculeCollisionSpec;
    }

    public void doCollision(MRModel mRModel, Body body, Body body2, MoleculeMoleculeCollisionSpec moleculeMoleculeCollisionSpec) {
        MutableVector2D mutableVector2D = moleculeMoleculeCollisionSpec.getLoa();
        Point2D.Double double_ = moleculeMoleculeCollisionSpec.getCollisionPt();
        if (mutableVector2D.magnitude() == 0.0) {
            return;
        }
        mRModel.getReaction();
        if (!Reaction.moleculesAreProperTypes((AbstractMolecule)body, (AbstractMolecule)body2)) {
            this.doHardSphereCollision(double_, body, body2, mutableVector2D);
        } else {
            SimpleMolecule simpleMolecule = moleculeMoleculeCollisionSpec.getFreeMolecule();
            SimpleMolecule simpleMolecule2 = moleculeMoleculeCollisionSpec.getSimpleMoleculeB();
            EnergyProfile energyProfile = mRModel.getEnergyProfile();
            double d = Math.max(simpleMolecule.getRadius(), simpleMolecule2.getRadius());
            double d2 = moleculeMoleculeCollisionSpec.getCompositeMolecule() instanceof MoleculeAB ? energyProfile.getRightLevel() : energyProfile.getLeftLevel();
            double d3 = energyProfile.getPeakLevel() - d2;
            double d4 = Math.atan2(d3, d);
            boolean bl = false;
            boolean bl2 = false;
            double d5 = mRModel.getReaction().getDistanceToCollision(moleculeMoleculeCollisionSpec.getFreeMolecule(), moleculeMoleculeCollisionSpec.getCompositeMolecule());
            double d6 = MRModelUtil.getCollisionEnergy(moleculeMoleculeCollisionSpec.getFreeMolecule(), moleculeMoleculeCollisionSpec.getCompositeMolecule());
            boolean bl3 = bl2 = -d5 >= d && d6 > d3;
            if (bl2) {
                A_BC_AB_C_Reaction a_BC_AB_C_Reaction = (A_BC_AB_C_Reaction)mRModel.getReaction();
                a_BC_AB_C_Reaction.doReaction(moleculeMoleculeCollisionSpec.getCompositeMolecule(), moleculeMoleculeCollisionSpec.getFreeMolecule());
                return;
            }
            double d7 = Math.tan(d4) * Math.abs(d5);
            boolean bl4 = bl = d7 > d6;
            if (bl) {
                this.doHardSphereCollision(double_, body, body2, mutableVector2D);
            }
            if (moleculeMoleculeCollisionSpec.getSimpleMoleculeA() instanceof MoleculeA && moleculeMoleculeCollisionSpec.getSimpleMoleculeB() instanceof MoleculeC || moleculeMoleculeCollisionSpec.getSimpleMoleculeA() instanceof MoleculeC && moleculeMoleculeCollisionSpec.getSimpleMoleculeB() instanceof MoleculeA) {
                this.doHardSphereCollision(double_, body, body2, mutableVector2D);
            }
        }
    }

    private void doHardSphereCollision(Point2D.Double double_, Body body, Body body2, MutableVector2D mutableVector2D) {
        MutableVector2D mutableVector2D2 = new MutableVector2D(double_.getX() - body.getPosition().getX(), double_.getY() - body.getPosition().getY());
        MutableVector2D mutableVector2D3 = new MutableVector2D(double_.getX() - body2.getPosition().getX(), double_.getY() - body2.getPosition().getY());
        this.n.setComponents(mutableVector2D.getX(), mutableVector2D.getY());
        if (this.n.magnitude() == 0.0) {
            System.out.println("MoleculeMoleculeCollisionAgent.doCollision");
        }
        this.n.normalize();
        this.vRel.setComponents(body.getVelocity().getX(), body.getVelocity().getY());
        this.vRel.subtract(body2.getVelocity());
        if (this.vRel.dot(this.n) <= 0.0) {
            this.vAng1.setComponents(-body.getOmega() * mutableVector2D2.getY(), body.getOmega() * mutableVector2D2.getX());
            this.vAng2.setComponents(-body2.getOmega() * mutableVector2D3.getY(), body2.getOmega() * mutableVector2D3.getX());
            this.angRel.setComponents(this.vAng1.getX(), this.vAng1.getY());
            this.angRel.subtract(this.vAng2);
            double d = this.vRel.dot(this.n) + this.angRel.dot(this.n);
            double d2 = 1.0;
            double d3 = -d * (1.0 + d2);
            Vector3D vector3D = new Vector3D(this.n);
            Vector3D vector3D2 = new Vector3D(mutableVector2D2);
            Vector3D vector3D3 = vector3D2.crossProduct(vector3D).multiply(1.0 / body.getMomentOfInertia());
            Vector3D vector3D4 = vector3D3.crossProduct(vector3D2);
            double d4 = vector3D.dot(vector3D4);
            Vector3D vector3D5 = new Vector3D(mutableVector2D3);
            Vector3D vector3D6 = vector3D5.crossProduct(vector3D).multiply(1.0 / body2.getMomentOfInertia());
            Vector3D vector3D7 = vector3D6.crossProduct(vector3D5);
            double d5 = vector3D.dot(vector3D7);
            double d6 = 1.0 / body.getMass() + 1.0 / body2.getMass() + d4 + d5;
            double d7 = d3 / d6;
            body.getVelocity().add(new MutableVector2D(this.n).scale(d7 / body.getMass()));
            body2.getVelocity().add(new MutableVector2D(this.n).scale(-d7 / body2.getMass()));
            double d8 = (mutableVector2D2.getX() * this.n.getY() - mutableVector2D2.getY() * this.n.getX()) * d7 / body.getMomentOfInertia();
            double d9 = (mutableVector2D3.getX() * this.n.getY() - mutableVector2D3.getY() * this.n.getX()) * -d7 / body2.getMomentOfInertia();
            body.setOmega(body.getOmega() + d8);
            body2.setOmega(body2.getOmega() + d9);
        }
    }
}

