/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.model.collision;

import edu.colorado.phet.common.mechanics.Body;
import edu.colorado.phet.common.mechanics.Vector3D;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.reactionsandrates.model.AbstractMolecule;
import edu.colorado.phet.reactionsandrates.model.CompositeMolecule;
import edu.colorado.phet.reactionsandrates.model.SimpleMolecule;
import java.awt.geom.Point2D;

public class HardBodyCollision {
    private MutableVector2D n = new MutableVector2D();
    private MutableVector2D vRel = new MutableVector2D();
    private MutableVector2D vAng1 = new MutableVector2D();
    private MutableVector2D vAng2 = new MutableVector2D();
    private MutableVector2D angRel = new MutableVector2D();
    private MutableVector2D loa = new MutableVector2D();

    public boolean detectAndDoCollision(Body body, Body body2) {
        AbstractMolecule abstractMolecule = (AbstractMolecule)body;
        AbstractMolecule abstractMolecule2 = (AbstractMolecule)body2;
        CollisionSpec collisionSpec = null;
        boolean bl = false;
        double d = Math.abs(abstractMolecule.getPosition().getX() - abstractMolecule2.getPosition().getX());
        double d2 = Math.abs(abstractMolecule.getPosition().getY() - abstractMolecule2.getPosition().getY());
        boolean bl2 = bl = d <= abstractMolecule.getBoundingBox().getWidth() + abstractMolecule2.getBoundingBox().getWidth() && d2 < abstractMolecule.getBoundingBox().getHeight() + abstractMolecule2.getBoundingBox().getHeight();
        if (bl && (collisionSpec = this.getCollisionSpec(abstractMolecule, abstractMolecule2)) != null) {
            this.doCollision(abstractMolecule, abstractMolecule2, collisionSpec);
        }
        return collisionSpec != null;
    }

    private CollisionSpec getCollisionSpec(AbstractMolecule abstractMolecule, AbstractMolecule abstractMolecule2) {
        CollisionSpec collisionSpec = null;
        if (abstractMolecule instanceof SimpleMolecule && abstractMolecule2 instanceof SimpleMolecule) {
            SimpleMolecule simpleMolecule = (SimpleMolecule)abstractMolecule;
            SimpleMolecule simpleMolecule2 = (SimpleMolecule)abstractMolecule2;
            if (simpleMolecule.getPosition().distanceSq(simpleMolecule2.getPosition()) <= (simpleMolecule.getRadius() + simpleMolecule2.getRadius()) * (simpleMolecule.getRadius() + simpleMolecule2.getRadius())) {
                double d = simpleMolecule.getCM().getX() - simpleMolecule2.getCM().getX();
                double d2 = simpleMolecule.getCM().getY() - simpleMolecule2.getCM().getY();
                double d3 = simpleMolecule.getRadius() / (simpleMolecule.getRadius() + simpleMolecule2.getRadius());
                Point2D.Double double_ = new Point2D.Double(simpleMolecule.getCM().getX() - d * d3, simpleMolecule.getCM().getY() - d2 * d3);
                this.loa.setComponents(d, d2);
                collisionSpec = new CollisionSpec(this.loa, double_, (SimpleMolecule)abstractMolecule, (SimpleMolecule)abstractMolecule2);
            }
        } else if (abstractMolecule instanceof CompositeMolecule) {
            CompositeMolecule compositeMolecule = (CompositeMolecule)abstractMolecule;
            for (int i = 0; i < compositeMolecule.getComponentMolecules().length && collisionSpec == null; ++i) {
                SimpleMolecule simpleMolecule = compositeMolecule.getComponentMolecules()[i];
                collisionSpec = this.getCollisionSpec(simpleMolecule, abstractMolecule2);
            }
        } else if (abstractMolecule2 instanceof CompositeMolecule) {
            CompositeMolecule compositeMolecule = (CompositeMolecule)abstractMolecule2;
            for (int i = 0; i < compositeMolecule.getComponentMolecules().length && collisionSpec == null; ++i) {
                SimpleMolecule simpleMolecule = compositeMolecule.getComponentMolecules()[i];
                collisionSpec = this.getCollisionSpec(abstractMolecule, simpleMolecule);
            }
        } else {
            throw new RuntimeException("error in function");
        }
        return collisionSpec;
    }

    public void doCollision(Body body, Body body2, CollisionSpec collisionSpec) {
        MutableVector2D mutableVector2D = new MutableVector2D(body.getMomentum()).add(body2.getMomentum());
        MutableVector2D mutableVector2D2 = collisionSpec.getLoa();
        Point2D.Double double_ = collisionSpec.getCollisionPt();
        double d = body.getKineticEnergy() + body2.getKineticEnergy();
        MutableVector2D mutableVector2D3 = new MutableVector2D(double_.getX() - body.getPosition().getX(), double_.getY() - body.getPosition().getY());
        MutableVector2D mutableVector2D4 = new MutableVector2D(double_.getX() - body2.getPosition().getX(), double_.getY() - body2.getPosition().getY());
        this.n.setComponents(mutableVector2D2.getX(), mutableVector2D2.getY());
        this.n.normalize();
        this.vRel.setComponents(body.getVelocity().getX(), body.getVelocity().getY());
        this.vRel.subtract(body2.getVelocity());
        if (this.vRel.dot(this.n) <= 0.0) {
            this.vAng1.setComponents(-body.getOmega() * mutableVector2D3.getY(), body.getOmega() * mutableVector2D3.getX());
            this.vAng2.setComponents(-body2.getOmega() * mutableVector2D4.getY(), body2.getOmega() * mutableVector2D4.getX());
            this.angRel.setComponents(this.vAng1.getX(), this.vAng1.getY());
            this.angRel.subtract(this.vAng2);
            double d2 = this.vRel.dot(this.n) + this.angRel.dot(this.n);
            double d3 = 1.0;
            double d4 = -d2 * (1.0 + d3);
            Vector3D vector3D = new Vector3D(this.n);
            Vector3D vector3D2 = new Vector3D(mutableVector2D3);
            Vector3D vector3D3 = vector3D2.crossProduct(vector3D).multiply(1.0 / body.getMomentOfInertia());
            Vector3D vector3D4 = vector3D3.crossProduct(vector3D2);
            double d5 = vector3D.dot(vector3D4);
            Vector3D vector3D5 = new Vector3D(mutableVector2D4);
            Vector3D vector3D6 = vector3D5.crossProduct(vector3D).multiply(1.0 / body2.getMomentOfInertia());
            Vector3D vector3D7 = vector3D6.crossProduct(vector3D5);
            double d6 = vector3D.dot(vector3D7);
            double d7 = 1.0 / body.getMass() + 1.0 / body2.getMass() + d5 + d6;
            double d8 = d4 / d7;
            body.getVelocity().add(new MutableVector2D(this.n).scale(d8 / body.getMass()));
            body2.getVelocity().add(new MutableVector2D(this.n).scale(-d8 / body2.getMass()));
            double d9 = (mutableVector2D3.getX() * this.n.getY() - mutableVector2D3.getY() * this.n.getX()) * d8 / body.getMomentOfInertia();
            double d10 = (mutableVector2D4.getX() * this.n.getY() - mutableVector2D4.getY() * this.n.getX()) * -d8 / body2.getMomentOfInertia();
            body.setOmega(body.getOmega() + d9);
            body2.setOmega(body2.getOmega() + d10);
            double d11 = body.getKineticEnergy();
            double d12 = body2.getKineticEnergy();
            double d13 = body.getKineticEnergy() + body2.getKineticEnergy();
            double d14 = d - d13;
        }
        MutableVector2D mutableVector2D5 = new MutableVector2D(body.getMomentum()).add(body2.getMomentum());
    }

    private static class CollisionSpec {
        private MutableVector2D loa;
        private Point2D.Double collisionPt;
        private SimpleMolecule moleculeA;
        private SimpleMolecule moleculeB;

        public CollisionSpec(MutableVector2D mutableVector2D, Point2D.Double double_, SimpleMolecule simpleMolecule, SimpleMolecule simpleMolecule2) {
            this.moleculeB = simpleMolecule2;
            this.moleculeA = simpleMolecule;
            this.loa = mutableVector2D;
            this.collisionPt = double_;
        }

        public MutableVector2D getLoa() {
            return this.loa;
        }

        public Point2D.Double getCollisionPt() {
            return this.collisionPt;
        }
    }
}

