/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.model;

import edu.colorado.phet.common.mechanics.DefaultBody;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.reactionsandrates.model.AbstractMolecule;
import edu.colorado.phet.reactionsandrates.model.CompositeMolecule;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.model.SimpleMolecule;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.EventListener;

public class TemperatureControl
extends DefaultBody {
    private MRModel model;
    private double setting;
    private EventChannel changeEventChannel = new EventChannel(ChangeListener.class);
    private ChangeListener changeListenerProxy = (ChangeListener)this.changeEventChannel.getListenerProxy();

    public TemperatureControl(MRModel mRModel) {
        this.model = mRModel;
    }

    public void stepInTime(double d) {
        if (this.setting != 0.0) {
            double d2 = 0.0;
            ArrayList arrayList = this.model.getModelElements();
            double d3 = 1.0 + this.setting / 10000.0;
            for (int i = 0; i < arrayList.size(); ++i) {
                double d4;
                double d5;
                AbstractMolecule abstractMolecule;
                Object e = arrayList.get(i);
                if (e instanceof SimpleMolecule && !((SimpleMolecule)e).isPartOfComposite()) {
                    abstractMolecule = (SimpleMolecule)e;
                    d5 = abstractMolecule.getKineticEnergy();
                    abstractMolecule.setVelocity(abstractMolecule.getVelocity().scale(d3));
                    d4 = abstractMolecule.getKineticEnergy();
                    d2 += d4 - d5;
                }
                if (!(e instanceof CompositeMolecule)) continue;
                abstractMolecule = (CompositeMolecule)e;
                d5 = abstractMolecule.getKineticEnergy();
                abstractMolecule.setOmega(abstractMolecule.getOmega() * d3);
                abstractMolecule.setVelocity(abstractMolecule.getVelocity().scale(d3));
                d4 = abstractMolecule.getKineticEnergy();
                d2 += d4 - d5;
            }
            this.model.addEnergy(d2);
        }
    }

    public void setPosition(double d, double d2) {
        super.setPosition(d, d2);
        this.changeListenerProxy.positionChanged(this.getPosition());
    }

    public void setPosition(Point2D point2D) {
        super.setPosition(point2D);
        this.changeListenerProxy.positionChanged(this.getPosition());
    }

    public void setSetting(double d) {
        this.setting = d;
        this.changeListenerProxy.settingChanged(d);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeEventChannel.addListener(changeListener);
    }

    public static interface ChangeListener
    extends EventListener {
        public void settingChanged(double var1);

        public void positionChanged(Point2D var1);
    }
}

