/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.model;

import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.reactionsandrates.model.AbstractMolecule;
import edu.colorado.phet.reactionsandrates.model.Selectable;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.EventListener;

public abstract class SimpleMolecule
extends AbstractMolecule
implements Selectable {
    private static double areaToMassFactor = 0.2;
    private double radius;
    private Rectangle2D boundingBox = new Rectangle2D.Double();
    private Selectable.Selection selectionStatus;
    private EventChannel eventChannel = new EventChannel(ChangeListener.class);
    private ChangeListener listenerProxy = (ChangeListener)this.eventChannel.getListenerProxy();

    public SimpleMolecule(double d) {
        this.radius = d;
        this.setMass(d * d * areaToMassFactor);
    }

    public Object clone() {
        SimpleMolecule simpleMolecule = (SimpleMolecule)super.clone();
        simpleMolecule.boundingBox = new Rectangle2D.Double(this.boundingBox.getX(), this.boundingBox.getY(), this.boundingBox.getWidth(), this.boundingBox.getHeight());
        simpleMolecule.eventChannel = new EventChannel(ChangeListener.class);
        simpleMolecule.listenerProxy = (ChangeListener)this.eventChannel.getListenerProxy();
        simpleMolecule.selectionStatus = null;
        return simpleMolecule;
    }

    public SimpleMolecule[] getComponentMolecules() {
        return new SimpleMolecule[]{this};
    }

    public Rectangle2D getBoundingBox() {
        this.boundingBox.setRect(this.getPosition().getX() - this.radius, this.getPosition().getY() - this.radius, this.radius * 2.0, this.radius * 2.0);
        return this.boundingBox;
    }

    public double getRadius() {
        return this.radius;
    }

    public Point2D getCM() {
        return this.getPosition();
    }

    public double getMomentOfInertia() {
        return this.radius * this.radius * this.getMass() / 2.0;
    }

    public double getFullMass() {
        if (this.isPartOfComposite()) {
            return this.getParentComposite().getMass();
        }
        return this.getMass();
    }

    public void setSelectionStatus(Selectable.Selection selection) {
        this.selectionStatus = selection;
        this.listenerProxy.selectionStatusChanged(this);
    }

    public Selectable.Selection getSelectionStatus() {
        return this.selectionStatus;
    }

    public void addListener(ChangeListener changeListener) {
        this.eventChannel.addListener(changeListener);
    }

    public void removeListener(ChangeListener changeListener) {
        this.eventChannel.removeListener(changeListener);
    }

    public static interface ChangeListener
    extends EventListener {
        public void selectionStatusChanged(SimpleMolecule var1);
    }
}

