/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.model;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.reactionsandrates.model.AbstractMolecule;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.model.PublishingModel;
import java.util.ArrayList;

public class MoleculeCounter
extends PublishingModel.ModelListenerAdapter
implements AbstractMolecule.ClassListener {
    private Class moleculeClass;
    private int cnt;
    private MRModel model;

    public MoleculeCounter(Class clazz, MRModel mRModel) {
        this.moleculeClass = clazz;
        this.model = mRModel;
        this.setMoleculeCount();
        mRModel.addListener(this);
        AbstractMolecule.addClassListener(this);
    }

    public int getCnt() {
        return this.cnt;
    }

    public void modelElementAdded(ModelElement modelElement) {
        if (this.moleculeClass.isInstance(modelElement)) {
            this.setMoleculeCount();
        }
    }

    public void modelElementRemoved(ModelElement modelElement) {
        if (this.moleculeClass.isInstance(modelElement)) {
            this.setMoleculeCount();
        }
    }

    private void setMoleculeCount() {
        ArrayList arrayList = this.model.getModelElements();
        int n = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            Object e = arrayList.get(i);
            if (!this.moleculeClass.isInstance(e) || ((AbstractMolecule)e).isPartOfComposite()) continue;
            ++n;
        }
        this.cnt = n;
    }

    public void statusChanged(AbstractMolecule abstractMolecule) {
        this.setMoleculeCount();
    }
}

