/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.model;

import edu.colorado.phet.common.collision.Box2D;
import edu.colorado.phet.common.mechanics.Body;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.reactionsandrates.MRConfig;
import edu.colorado.phet.reactionsandrates.model.AbstractMolecule;
import edu.colorado.phet.reactionsandrates.model.Bond;
import edu.colorado.phet.reactionsandrates.model.BoxHeater;
import edu.colorado.phet.reactionsandrates.model.CollisionAgent;
import edu.colorado.phet.reactionsandrates.model.CompositeMolecule;
import edu.colorado.phet.reactionsandrates.model.EnergyProfile;
import edu.colorado.phet.reactionsandrates.model.KineticEnergySource;
import edu.colorado.phet.reactionsandrates.model.MRBox;
import edu.colorado.phet.reactionsandrates.model.PotentialEnergySource;
import edu.colorado.phet.reactionsandrates.model.ProvisionalBond;
import edu.colorado.phet.reactionsandrates.model.PublishingModel;
import edu.colorado.phet.reactionsandrates.model.SelectedMoleculeTracker;
import edu.colorado.phet.reactionsandrates.model.SimpleMolecule;
import edu.colorado.phet.reactionsandrates.model.TemperatureControl;
import edu.colorado.phet.reactionsandrates.model.reactions.A_BC_AB_C_Reaction;
import edu.colorado.phet.reactionsandrates.model.reactions.Reaction;
import java.awt.geom.Point2D;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class MRModel
extends PublishingModel {
    private MRBox box;
    private Reaction reaction;
    private SelectedMoleculeTracker selectedMoleculeTracker;
    private TemperatureControl tempCtrl;
    private double dEnergy;
    private double defaultTemperature = 100.0;
    private boolean averageTotal;
    private EventChannel modelEventChannel = new EventChannel(ModelListener.class);
    private ModelListener modelListenerProxy = (ModelListener)this.modelEventChannel.getListenerProxy();

    public MRModel(IClock iClock) {
        super(iClock);
        this.setInitialConditions();
        this.addListener(new CompositeMolecule.DependentModelElementMonitor(this));
    }

    public void setInitialConditions() {
        this.reaction = new A_BC_AB_C_Reaction(this);
        this.setEnergyProfile(MRConfig.DEFAULT_ENERGY_PROFILE);
        this.box = new MRBox(new Point2D.Double(30.0, 30.0), new Point2D.Double(380.0, 330.0), 0.0, this);
        this.addModelElement(this.box);
        this.tempCtrl = new TemperatureControl(this);
        this.tempCtrl.setPosition((this.getBox().getMaxX() + this.getBox().getMinX()) / 2.0, this.getBox().getMaxY() + 15.0);
        this.addModelElement(this.tempCtrl);
        new BoxHeater(this.tempCtrl, this.box);
        this.addModelElement(new CollisionAgent(this));
        this.selectedMoleculeTracker = new SelectedMoleculeTracker(this);
        this.addModelElement(this.selectedMoleculeTracker);
    }

    public Reaction getReaction() {
        return this.reaction;
    }

    public void setEnergyProfile(EnergyProfile energyProfile) {
        this.getReaction().setEnergyProfile(energyProfile);
        this.modelListenerProxy.notifyEnergyProfileChanged(energyProfile);
    }

    public EnergyProfile getEnergyProfile() {
        return this.reaction.getEnergyProfile();
    }

    public Box2D getBox() {
        return this.box;
    }

    public TemperatureControl getTemperatureControl() {
        return this.tempCtrl;
    }

    public SimpleMolecule getMoleculeBeingTracked() {
        return this.selectedMoleculeTracker.getMoleculeTracked();
    }

    public SimpleMolecule getNearestToMoleculeBeingTracked() {
        return this.selectedMoleculeTracker.getClosestMolecule();
    }

    public void addSelectedMoleculeTrackerListener(SelectedMoleculeTracker.Listener listener) {
        this.selectedMoleculeTracker.addListener(listener);
    }

    public void removeSelectedMoleculeTrackerListener(SelectedMoleculeTracker.Listener listener) {
        this.selectedMoleculeTracker.removeListener(listener);
    }

    protected void stepInTime(double d) {
        this.dEnergy = 0.0;
        double d2 = this.getTotalPotentialEnergy();
        double d3 = this.getTotalKineticEnergy();
        super.stepInTime(d);
        double d4 = this.getTotalPotentialEnergy();
        double d5 = this.getTotalKineticEnergy();
        double d6 = d2 + d3 - d4 + this.dEnergy;
        double d7 = Math.sqrt(d5 != 0.0 ? d6 / d5 : 1.0);
        List list = this.selectFor(Body.class);
        for (int i = 0; i < list.size(); ++i) {
            Body body = (Body)list.get(i);
            body.setVelocity(body.getVelocity().scale(d7));
            body.setOmega(body.getOmega() * d7);
        }
    }

    public double getTotalKineticEnergy() {
        double d = 0.0;
        List list = this.selectFor(new Class[]{Body.class, KineticEnergySource.class});
        for (int i = 0; i < list.size(); ++i) {
            Body body = (Body)list.get(i);
            d += body.getKineticEnergy();
        }
        return d;
    }

    public double getTemperature() {
        int n = this.countWholeMolecules();
        return n > 0 ? this.getTotalKineticEnergy() / (double)n : this.getDefaultTemperature();
    }

    public double getDefaultTemperature() {
        return this.defaultTemperature;
    }

    public void setDefaultTemperature(double d) {
        this.defaultTemperature = d;
        this.modelListenerProxy.notifyDefaultTemperatureChanged(d);
    }

    public double getAverageKineticEnergyPerClass() {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        List list = this.selectFor(Body.class);
        for (int i = 0; i < list.size(); ++i) {
            Body body = (Body)list.get(i);
            Class<?> clazz = body.getClass();
            if (body instanceof AbstractMolecule && ((AbstractMolecule)body).isPartOfComposite()) continue;
            double d = hashMap.containsKey(clazz) ? (Double)hashMap.get(clazz) : 0.0;
            int n = hashMap2.containsKey(clazz) ? (Integer)hashMap2.get(clazz) : 0;
            hashMap.put(clazz, new Double(d + body.getKineticEnergy()));
            hashMap2.put(clazz, new Integer(n + 1));
        }
        Iterator iterator = hashMap.keySet().iterator();
        double d = 0.0;
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            double d2 = (Double)hashMap.get(clazz);
            int n = (Integer)hashMap2.get(clazz);
            d += d2 / (double)n;
        }
        return d;
    }

    public double getAveragePotentialEnergyPerClass() {
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        List list = this.selectFor(PotentialEnergySource.class);
        for (int i = 0; i < list.size(); ++i) {
            PotentialEnergySource potentialEnergySource = (PotentialEnergySource)list.get(i);
            Class<?> clazz = potentialEnergySource.getClass();
            if (potentialEnergySource instanceof AbstractMolecule && ((AbstractMolecule)((Object)potentialEnergySource)).isPartOfComposite()) continue;
            double d = hashMap.containsKey(clazz) ? (Double)hashMap.get(clazz) : 0.0;
            int n = hashMap2.containsKey(clazz) ? (Integer)hashMap2.get(clazz) : 0;
            hashMap.put(clazz, new Double(d + potentialEnergySource.getPE()));
            hashMap2.put(clazz, new Integer(n + 1));
        }
        Iterator iterator = hashMap.keySet().iterator();
        double d = 0.0;
        while (iterator.hasNext()) {
            Class clazz = (Class)iterator.next();
            double d2 = (Double)hashMap.get(clazz);
            int n = (Integer)hashMap2.get(clazz);
            d += d2 / (double)n;
        }
        return d;
    }

    public double getTotalPotentialEnergy() {
        double d = 0.0;
        List list = this.selectFor(PotentialEnergySource.class);
        for (int i = 0; i < list.size(); ++i) {
            PotentialEnergySource potentialEnergySource = (PotentialEnergySource)list.get(i);
            d += potentialEnergySource.getPE();
        }
        return d;
    }

    public void addEnergy(double d) {
        this.dEnergy += d;
    }

    public void removeAllMolecules() {
        List list = this.selectForAny(new Class[]{AbstractMolecule.class, Bond.class, ProvisionalBond.class});
        for (int i = list.size() - 1; i >= 0; --i) {
            ModelElement modelElement = (ModelElement)list.get(i);
            this.removeModelElement(modelElement);
        }
    }

    private double getAverageTotalEnergy() {
        int n = this.countWholeMolecules();
        if (n != 0) {
            return this.getTotalKineticEnergy() / (double)n;
        }
        return this.getDefaultTemperature();
    }

    public void setAverageTotal(boolean bl) {
        this.averageTotal = bl;
    }

    public double getTotalEnergy() {
        if (this.averageTotal) {
            return this.getAverageTotalEnergy();
        }
        int n = this.countWholeMolecules();
        if (n != 0) {
            return this.getAverageKineticEnergyPerClass() + this.getAveragePotentialEnergyPerClass();
        }
        return this.getDefaultTemperature();
    }

    public void addListener(ModelListener modelListener) {
        this.modelEventChannel.addListener(modelListener);
    }

    public void removeListener(ModelListener modelListener) {
        this.modelEventChannel.removeListener(modelListener);
    }

    public int countWholeMolecules() {
        int n = 0;
        List list = this.selectFor(AbstractMolecule.class);
        for (int i = 0; i < list.size(); ++i) {
            AbstractMolecule abstractMolecule = (AbstractMolecule)list.get(i);
            if (!abstractMolecule.isWholeMolecule()) continue;
            ++n;
        }
        return n;
    }

    public static interface ModelListener
    extends EventListener {
        public void notifyEnergyProfileChanged(EnergyProfile var1);

        public void notifyDefaultTemperatureChanged(double var1);
    }

    public static class ModelListenerAdapter
    implements ModelListener {
        public void notifyEnergyProfileChanged(EnergyProfile energyProfile) {
        }

        public void notifyDefaultTemperatureChanged(double d) {
        }
    }
}

