/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.model;

import edu.colorado.phet.common.mechanics.Body;
import edu.colorado.phet.common.mechanics.Vector3D;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.reactionsandrates.model.AbstractMolecule;
import edu.colorado.phet.reactionsandrates.model.Bond;
import edu.colorado.phet.reactionsandrates.model.PotentialEnergySource;
import edu.colorado.phet.reactionsandrates.model.PublishingModel;
import edu.colorado.phet.reactionsandrates.model.SimpleMolecule;
import edu.colorado.phet.reactionsandrates.model.collision.HardBodyCollision;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventListener;

public abstract class CompositeMolecule
extends AbstractMolecule
implements PotentialEnergySource {
    private SimpleMolecule[] components;
    private Rectangle2D boundingBox = new Rectangle2D.Double();
    private double orientation;
    private Bond[] bonds;
    private EventChannel eventChannel = new EventChannel(Listener.class);
    Listener listenerProxy = (Listener)this.eventChannel.getListenerProxy();

    public Object clone() {
        CompositeMolecule compositeMolecule = (CompositeMolecule)super.clone();
        compositeMolecule.components = (SimpleMolecule[])this.components.clone();
        compositeMolecule.boundingBox = new Rectangle2D.Double(this.boundingBox.getX(), this.boundingBox.getY(), this.boundingBox.getWidth(), this.boundingBox.getHeight());
        compositeMolecule.bonds = (Bond[])this.bonds.clone();
        return compositeMolecule;
    }

    protected CompositeMolecule() {
    }

    public CompositeMolecule(SimpleMolecule[] simpleMoleculeArray) {
        this.setComponents(simpleMoleculeArray);
    }

    public Bond[] getBonds() {
        if (this.bonds == null && this.getComponentMolecules().length >= 1) {
            this.bonds = new Bond[]{new Bond(this.getComponentMolecules()[0], this.getComponentMolecules()[1])};
        }
        return this.bonds;
    }

    protected void setComponents(SimpleMolecule[] simpleMoleculeArray) {
        this.components = simpleMoleculeArray;
        for (int i = 0; i < simpleMoleculeArray.length; ++i) {
            SimpleMolecule simpleMolecule = simpleMoleculeArray[i];
            simpleMolecule.setParentComposite(this);
        }
        this.computeKinematicsFromComponents(simpleMoleculeArray);
    }

    public void removeSimpleMolecule(SimpleMolecule simpleMolecule) {
        ArrayList<SimpleMolecule> arrayList = new ArrayList<SimpleMolecule>(Arrays.asList(this.components));
        arrayList.remove(simpleMolecule);
        this.components = arrayList.toArray(new SimpleMolecule[arrayList.size()]);
        simpleMolecule.setParentComposite(null);
        this.computeKinematicsFromComponents(this.components);
        HardBodyCollision hardBodyCollision = new HardBodyCollision();
        this.setMomentum(this.getMomentum().add(simpleMolecule.getMomentum()));
        simpleMolecule.setVelocity(0.0, 0.0);
        hardBodyCollision.detectAndDoCollision(this, simpleMolecule);
    }

    private void computeKinematicsFromComponents(AbstractMolecule[] abstractMoleculeArray) {
        int n;
        this.computeCM();
        double d = 0.0;
        MutableVector2D mutableVector2D = new MutableVector2D();
        MutableVector2D mutableVector2D2 = new MutableVector2D();
        Vector3D vector3D = new Vector3D();
        MutableVector2D mutableVector2D3 = new MutableVector2D();
        for (n = 0; n < abstractMoleculeArray.length; ++n) {
            AbstractMolecule abstractMolecule = abstractMoleculeArray[n];
            d += abstractMolecule.getMass();
            MutableVector2D mutableVector2D4 = new MutableVector2D(abstractMolecule.getVelocity()).scale(abstractMolecule.getMass());
            mutableVector2D.add(mutableVector2D4);
            mutableVector2D2.add(abstractMolecule.getAcceleration());
            mutableVector2D3.setComponents(abstractMolecule.getPosition().getX() - this.getCM().getX(), abstractMolecule.getPosition().getY() - this.getCM().getY());
            vector3D.add(Vector3D.createCrossProduct(mutableVector2D3, mutableVector2D4));
        }
        this.setMass(d);
        this.setVelocity(mutableVector2D.scale(1.0 / d));
        this.setAcceleration(mutableVector2D2);
        this.setOmega(vector3D.getZ() / this.getMomentOfInertia());
        for (n = 0; n < abstractMoleculeArray.length; ++n) {
            abstractMoleculeArray[n].setVelocity(this.getVelocity());
        }
    }

    protected AbstractMolecule getMoleculeOfType(Class clazz) {
        SimpleMolecule simpleMolecule = null;
        for (int i = 0; i < this.components.length && simpleMolecule == null; ++i) {
            if (!clazz.isInstance(this.components[i])) continue;
            simpleMolecule = this.components[i];
        }
        if (simpleMolecule == null) {
            throw new RuntimeException("internal error");
        }
        return simpleMolecule;
    }

    public SimpleMolecule[] getComponentMolecules() {
        return this.components;
    }

    public Rectangle2D getBoundingBox() {
        if (this.components.length >= 1) {
            this.boundingBox.setRect(this.components[0].getBoundingBox());
            for (int i = 1; i < this.components.length; ++i) {
                this.boundingBox = this.boundingBox.createUnion(this.components[i].getBoundingBox());
            }
        } else {
            this.boundingBox.setRect(0.0, 0.0, 0.0, 0.0);
        }
        return this.boundingBox;
    }

    public Point2D getCM() {
        return this.getPosition();
    }

    private void computeCM() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.components.length; ++i) {
            SimpleMolecule simpleMolecule = this.components[i];
            double d4 = simpleMolecule.getMass();
            d += d4 * ((Body)simpleMolecule).getCM().getX();
            d2 += d4 * ((Body)simpleMolecule).getCM().getY();
            d3 += d4;
        }
        this.setPosition(d / d3, d2 / d3);
    }

    public double getMomentOfInertia() {
        double d = 0.0;
        Point2D point2D = this.getCM();
        for (int i = 0; i < this.components.length; ++i) {
            SimpleMolecule simpleMolecule = this.components[i];
            double d2 = point2D.distance(((Body)simpleMolecule).getCM());
            double d3 = ((Body)simpleMolecule).getMomentOfInertia() + simpleMolecule.getMass() * d2 * d2;
            d += d3;
        }
        return d;
    }

    public double getOrientation() {
        return this.orientation;
    }

    public void setOrientation(double d) {
        this.orientation = d;
        this.notifyObservers();
    }

    public void stepInTime(double d) {
        double d2 = this.getOrientation();
        double d3 = this.getOmega();
        double d4 = this.getAlpha();
        double d5 = 0.0;
        double d6 = d3 * d + d5 * d * d / 2.0;
        double d7 = (d2 + d6) % (Math.PI * 2);
        double d8 = d3 + d5 * d;
        double d9 = d4;
        double d10 = d3 + this.getAlpha() * d;
        this.setOrientation(d7);
        this.setOmega(d10);
        this.setAlpha(d9);
        super.stepInTime(d);
        this.updateComponents(d6);
        this.notifyObservers();
    }

    public void updateComponents(double d) {
        for (int i = 0; i < this.components.length; ++i) {
            SimpleMolecule simpleMolecule = this.components[i];
            MutableVector2D mutableVector2D = new MutableVector2D(simpleMolecule.getPosition().getX() - this.getPositionPrev().getX(), simpleMolecule.getPosition().getY() - this.getPositionPrev().getY());
            mutableVector2D.rotate(d);
            simpleMolecule.setPosition(this.getPosition().getX() + mutableVector2D.getX(), this.getPosition().getY() + mutableVector2D.getY());
            MutableVector2D mutableVector2D2 = simpleMolecule.getVelocity();
            mutableVector2D2.setComponents(this.getVelocity().getX() + this.getOmega() * -mutableVector2D.getY(), this.getVelocity().getY() + this.getOmega() * mutableVector2D.getX());
        }
    }

    public void rotate(double d) {
        for (int i = 0; i < this.components.length; ++i) {
            SimpleMolecule simpleMolecule = this.components[i];
            MutableVector2D mutableVector2D = new MutableVector2D(this.getCM(), simpleMolecule.getPosition());
            mutableVector2D.rotate(d);
            simpleMolecule.setPosition(this.getCM().getX() + mutableVector2D.getX(), this.getCM().getY() + mutableVector2D.getY());
        }
    }

    public static class DependentModelElementMonitor
    extends PublishingModel.ModelListenerAdapter {
        private PublishingModel model;

        public DependentModelElementMonitor(PublishingModel publishingModel) {
            this.model = publishingModel;
        }

        public void modelElementAdded(ModelElement modelElement) {
            if (modelElement instanceof CompositeMolecule) {
                CompositeMolecule compositeMolecule = (CompositeMolecule)modelElement;
                Bond[] bondArray = compositeMolecule.getBonds();
                for (int i = 0; i < bondArray.length; ++i) {
                    Bond bond = bondArray[i];
                    if (this.model.getModelElements().contains(bond)) continue;
                    this.model.addModelElement(bond);
                }
            }
        }

        public void modelElementRemoved(ModelElement modelElement) {
            if (modelElement instanceof CompositeMolecule) {
                CompositeMolecule compositeMolecule = (CompositeMolecule)modelElement;
                Bond[] bondArray = compositeMolecule.getBonds();
                for (int i = 0; i < bondArray.length; ++i) {
                    Bond bond = bondArray[i];
                    if (!this.model.getModelElements().contains(bond)) continue;
                    this.model.removeModelElement(bond);
                }
            }
        }
    }

    public static interface Listener
    extends EventListener {
    }
}

