/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.model;

import edu.colorado.phet.common.mechanics.Body;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public class CompositeBody
extends Body {
    private ArrayList bodies;
    private Point2D.Double cm;
    private MutableVector2D velocity;

    public Point2D getCM() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (int i = 0; i < this.bodies.size(); ++i) {
            Body body = (Body)this.bodies.get(i);
            double d4 = body.getMass();
            d += d4 * body.getCM().getX();
            d2 += d4 * body.getCM().getY();
            d3 += d4;
        }
        this.cm.setLocation(d / d3, d2 / d3);
        return this.cm;
    }

    public double getMomentOfInertia() {
        double d = 0.0;
        Point2D point2D = this.getCM();
        for (int i = 0; i < this.bodies.size(); ++i) {
            Body body = (Body)this.bodies.get(i);
            double d2 = point2D.distance(body.getCM());
            double d3 = body.getMomentOfInertia() + body.getMass() * d2 * d2;
            d += d3;
        }
        return d;
    }

    public MutableVector2D getVelocity() {
        this.velocity.setComponents(0.0, 0.0);
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < this.bodies.size(); ++i) {
            Body body = (Body)this.bodies.get(i);
            d += body.getVelocity().getX() * body.getMass() / this.getMass();
            d2 += body.getVelocity().getY() * body.getMass() / this.getMass();
        }
        this.velocity.setComponents(d, d2);
        return this.velocity;
    }
}

