/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactionsandrates.model;

import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.reactionsandrates.model.AbstractMolecule;
import edu.colorado.phet.reactionsandrates.model.MRModel;
import edu.colorado.phet.reactionsandrates.model.collision.MRCollisionAgent;
import edu.colorado.phet.reactionsandrates.model.collision.MoleculeBoxCollisionAgent;
import edu.colorado.phet.reactionsandrates.model.collision.MoleculeMoleculeCollisionAgent_2;
import edu.colorado.phet.reactionsandrates.model.collision.SpringCollision;
import java.util.ArrayList;

public class CollisionAgent
implements ModelElement {
    private MRCollisionAgent moleculeMoleculeCollisionAgent;
    private MoleculeBoxCollisionAgent moleculeBoxCollisionAgent;
    private MRModel model;

    public CollisionAgent(MRModel mRModel) {
        this.model = mRModel;
        SpringCollision.Spring spring = new SpringCollision.Spring(10.0, mRModel.getReaction().getEnergyProfile().getThresholdWidth() / 2.0);
        this.moleculeMoleculeCollisionAgent = new MoleculeMoleculeCollisionAgent_2(mRModel);
        this.moleculeBoxCollisionAgent = new MoleculeBoxCollisionAgent(mRModel);
    }

    public void stepInTime(double d) {
        ArrayList arrayList = new ArrayList(this.model.getModelElements());
        for (int i = arrayList.size() - 1; i >= 0; --i) {
            int n;
            Object e = arrayList.get(i);
            if (!(e instanceof AbstractMolecule)) continue;
            boolean bl = false;
            AbstractMolecule abstractMolecule = (AbstractMolecule)e;
            if (abstractMolecule.isPartOfComposite()) continue;
            for (n = i - 1; n >= 0 && !bl; --n) {
                AbstractMolecule abstractMolecule2;
                Object e2 = arrayList.get(n);
                if (!(e2 instanceof AbstractMolecule) || (abstractMolecule2 = (AbstractMolecule)e2).isPartOfComposite() || abstractMolecule == abstractMolecule2) continue;
                bl = this.moleculeMoleculeCollisionAgent.detectAndDoCollision(this.model, abstractMolecule, abstractMolecule2);
            }
            n = this.moleculeBoxCollisionAgent.detectAndDoCollision(abstractMolecule, this.model.getBox()) ? 1 : 0;
            if (n == 0) continue;
            abstractMolecule.stepInTime(d);
            n = this.moleculeBoxCollisionAgent.detectAndDoCollision(abstractMolecule, this.model.getBox()) ? 1 : 0;
            if (n != 0) continue;
            abstractMolecule.stepInTime(-d);
        }
    }
}

