/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.piccolophet.services;

import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;

public class PNodeShowHideControl {
    private static final ImageIcon HIDE_IMAGE_ICON = new ImageIcon(PhetCommonResources.getMinimizeButtonImage());
    private static final ImageIcon SHOW_IMAGE_ICON = new ImageIcon(PhetCommonResources.getMaximizeButtonImage());
    private final PNode parent;
    private final List savedChildren = new ArrayList();
    private final JButton showHideButton;
    private final PSwing showHideButtonNode;
    private final PSwing restoreLabelNode;
    private volatile boolean isHidden = false;

    public PNodeShowHideControl(PNode pNode, String string) {
        this.parent = pNode;
        this.showHideButton = new JButton();
        this.showHideButtonNode = new PSwing(this.showHideButton);
        this.restoreLabelNode = new PSwing(new JLabel(string));
        this.initButton();
        this.hide();
        this.show();
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public void uninstall() {
        if (this.isHidden()) {
            this.show();
        }
        this.uninstallPSwing(this.restoreLabelNode);
        this.uninstallPSwing(this.showHideButtonNode);
    }

    public void hide() {
        if (this.isHidden()) {
            return;
        }
        this.savedChildren.clear();
        this.savedChildren.addAll(this.parent.getChildrenReference());
        this.parent.removeAllChildren();
        this.restoreButtonNodes();
        this.setClosedStatus(true);
    }

    public void show() {
        if (!this.isHidden()) {
            return;
        }
        this.parent.removeAllChildren();
        this.parent.addChildren(this.savedChildren);
        this.setClosedStatus(false);
    }

    private void uninstallPSwing(PSwing pSwing) {
        if (pSwing != null) {
            if (this.parent.getChildrenReference().contains(pSwing)) {
                this.parent.removeChild(pSwing);
            }
            pSwing.removeFromSwingWrapper();
        }
    }

    private void initButton() {
        this.restoreButtonNodes();
        this.showHideButtonNode.addPropertyChangeListener(new PositionSettingListener());
        this.showHideButton.addActionListener(new StateTogglingActionListener());
    }

    private void restoreButtonNodes() {
        this.parent.addChild(this.showHideButtonNode);
        this.parent.addChild(this.restoreLabelNode);
    }

    private void setClosedStatus(boolean bl) {
        this.isHidden = bl;
        this.setStateData();
        this.setPositions();
    }

    private void setStateData() {
        if (this.isHidden()) {
            this.setButtonIcon(SHOW_IMAGE_ICON);
            this.restoreLabelNode.setVisible(true);
        } else {
            this.setButtonIcon(HIDE_IMAGE_ICON);
            this.restoreLabelNode.setVisible(false);
        }
    }

    private void setButtonIcon(ImageIcon imageIcon) {
        if (imageIcon != null) {
            this.showHideButton.setIcon(imageIcon);
            this.showHideButton.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    private void setPositions() {
        PBounds pBounds = this.parent.getBounds();
        double d = pBounds.getMaxX() - this.showHideButtonNode.getWidth() - 2.0;
        double d2 = pBounds.getMinY() + 2.0;
        this.showHideButtonNode.setOffset(d, d2);
        if (this.showHideButtonNode.getParent() != null && this.showHideButtonNode.getParent().getChildrenReference().contains(this.showHideButtonNode)) {
            this.showHideButtonNode.moveToFront();
        }
        this.restoreLabelNode.setOffset(d - this.restoreLabelNode.getWidth() - 2.0, d2);
        if (this.restoreLabelNode.getParent() != null && this.restoreLabelNode.getParent().getChildrenReference().contains(this.restoreLabelNode)) {
            this.restoreLabelNode.moveToFront();
        }
    }

    private class PositionSettingListener
    implements PropertyChangeListener {
        private volatile boolean propertyIsChanging = false;

        private PositionSettingListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (!this.propertyIsChanging) {
                this.propertyIsChanging = true;
                try {
                    PNodeShowHideControl.this.setPositions();
                }
                finally {
                    this.propertyIsChanging = false;
                }
            }
        }
    }

    private class StateTogglingActionListener
    implements ActionListener {
        private StateTogglingActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (PNodeShowHideControl.this.isHidden()) {
                PNodeShowHideControl.this.show();
            } else {
                PNodeShowHideControl.this.hide();
            }
        }
    }
}

