/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.util;

import edu.colorado.phet.common.phetcommon.util.DynamicListenerController;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;

public class DynamicListenerControllerFactory {
    public static DynamicListenerController newController(Class clazz) {
        if (!clazz.isInterface()) {
            throw new IllegalStateException("The specified class must be an interface.");
        }
        DynamicListenerControllerImpl dynamicListenerControllerImpl = new DynamicListenerControllerImpl(clazz);
        return (DynamicListenerController)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz, DynamicListenerController.class}, (InvocationHandler)dynamicListenerControllerImpl);
    }

    private static class DynamicListenerControllerImpl
    implements DynamicListenerController,
    InvocationHandler {
        private Collection listeners = new HashSet();
        private final Class listenerInterface;

        DynamicListenerControllerImpl(Class clazz) {
            this.listenerInterface = clazz;
        }

        public Collection getAllListeners() {
            return Collections.unmodifiableCollection(this.listeners);
        }

        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (method.getDeclaringClass() == Object.class) {
                return method.invoke((Object)this, objectArray);
            }
            if (method.getDeclaringClass() == DynamicListenerController.class) {
                try {
                    return method.invoke((Object)this, objectArray);
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw invocationTargetException.getTargetException();
                }
            }
            if (method.getReturnType() == Void.TYPE) {
                for (Object e : this.getAllListeners()) {
                    method.invoke(e, objectArray);
                }
                return null;
            }
            throw new IllegalStateException("Cannot implement method " + method);
        }
    }
}

