/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.model.clock;

import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ClockListener;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.util.EventChannel;

public class VariableConstantTickClock
implements ClockListener,
IClock {
    private IClock wrappedClock;
    private double dt;
    private EventChannel clockEventChannel = new EventChannel(ClockListener.class);
    private ClockListener clockListenerProxy = (ClockListener)this.clockEventChannel.getListenerProxy();

    public VariableConstantTickClock(IClock iClock, double d) {
        this.wrappedClock = iClock;
        this.wrappedClock.addClockListener(this);
        this.dt = d;
    }

    public void setDt(double d) {
        this.dt = d;
    }

    public void clockTicked(ClockEvent clockEvent) {
        ClockEvent clockEvent2 = new ClockEvent(this);
        this.clockListenerProxy.clockTicked(clockEvent2);
    }

    public void clockStarted(ClockEvent clockEvent) {
        ClockEvent clockEvent2 = new ClockEvent(this);
        this.clockListenerProxy.clockStarted(clockEvent2);
    }

    public void clockPaused(ClockEvent clockEvent) {
        ClockEvent clockEvent2 = new ClockEvent(this);
        this.clockListenerProxy.clockPaused(clockEvent2);
    }

    public void simulationTimeChanged(ClockEvent clockEvent) {
        ClockEvent clockEvent2 = new ClockEvent(this);
        this.clockListenerProxy.simulationTimeChanged(clockEvent2);
    }

    public void simulationTimeReset(ClockEvent clockEvent) {
        ClockEvent clockEvent2 = new ClockEvent(this);
        this.clockListenerProxy.simulationTimeReset(clockEvent2);
    }

    public double getSimulationTimeChange() {
        return this.dt;
    }

    public void addClockListener(ClockListener clockListener) {
        this.clockEventChannel.addListener(clockListener);
    }

    public void removeClockListener(ClockListener clockListener) {
        this.clockEventChannel.removeListener(clockListener);
    }

    public void start() {
        this.wrappedClock.start();
    }

    public void pause() {
        this.wrappedClock.pause();
    }

    public boolean isPaused() {
        return this.wrappedClock.isPaused();
    }

    public boolean isRunning() {
        return this.wrappedClock.isRunning();
    }

    public void resetSimulationTime() {
        this.wrappedClock.resetSimulationTime();
    }

    public double getSimulationTime() {
        return this.wrappedClock.getSimulationTime();
    }

    public void stepClockWhilePaused() {
        this.wrappedClock.stepClockWhilePaused();
    }

    public void stepClockBackWhilePaused() {
        this.wrappedClock.stepClockBackWhilePaused();
    }
}

