/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.model;

import edu.colorado.phet.common.phetcommon.model.CommandQueue;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import java.util.ArrayList;
import java.util.List;

public class BaseModel {
    private CommandQueue commandList = new CommandQueue();
    private ArrayList modelElements = new ArrayList();

    public void addModelElement(ModelElement modelElement) {
        this.modelElements.add(modelElement);
    }

    public ModelElement modelElementAt(int n) {
        return (ModelElement)this.modelElements.get(n);
    }

    public int numModelElements() {
        return this.modelElements.size();
    }

    public void removeModelElement(ModelElement modelElement) {
        this.modelElements.remove(modelElement);
    }

    public void update(ClockEvent clockEvent) {
        this.commandList.doIt();
        double d = clockEvent.getSimulationTimeChange();
        this.stepInTime(d);
    }

    protected void stepInTime(double d) {
        for (int i = 0; i < this.numModelElements(); ++i) {
            this.modelElementAt(i).stepInTime(d);
        }
    }

    public List selectForAny(Class[] classArray) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.modelElements.size(); ++i) {
            for (int j = 0; j < classArray.length; ++j) {
                Class clazz = classArray[j];
                Object e = this.modelElements.get(i);
                if (!clazz.isAssignableFrom(e.getClass())) continue;
                arrayList.add(e);
            }
        }
        return arrayList;
    }

    public List selectFor(Class clazz) {
        return BaseModel.selectFor(this.modelElements, clazz);
    }

    public List selectFor(Class[] classArray) {
        List list = new ArrayList(this.modelElements);
        for (int i = 0; i < classArray.length; ++i) {
            Class clazz = classArray[i];
            list = BaseModel.selectFor(list, clazz);
        }
        return list;
    }

    private static List selectFor(List list, Class clazz) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            Object e = list.get(i);
            if (!clazz.isAssignableFrom(e.getClass())) continue;
            arrayList.add(e);
        }
        return arrayList;
    }
}

