/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.math.vector;

import edu.colorado.phet.common.phetcommon.math.vector.AbstractVector2D;
import java.awt.geom.Point2D;

public class MutableVector2D
extends AbstractVector2D {
    private double x;
    private double y;

    public MutableVector2D() {
    }

    public MutableVector2D(AbstractVector2D abstractVector2D) {
        this(abstractVector2D.getX(), abstractVector2D.getY());
    }

    public MutableVector2D(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public MutableVector2D(Point2D point2D, Point2D point2D2) {
        this.x = point2D2.getX() - point2D.getX();
        this.y = point2D2.getY() - point2D.getY();
    }

    public MutableVector2D add(AbstractVector2D abstractVector2D) {
        this.setX(this.getX() + abstractVector2D.getX());
        this.setY(this.getY() + abstractVector2D.getY());
        return this;
    }

    public MutableVector2D normalize() {
        double d = this.magnitude();
        if (d == 0.0) {
            throw new UnsupportedOperationException("Cannot normalize a zero-magnitude vector.");
        }
        return this.scale(1.0 / d);
    }

    public MutableVector2D scale(double d) {
        this.setX(this.getX() * d);
        this.setY(this.getY() * d);
        return this;
    }

    public void setX(double d) {
        this.x = d;
    }

    public void setY(double d) {
        this.y = d;
    }

    public void setComponents(double d, double d2) {
        this.setX(d);
        this.setY(d2);
    }

    public MutableVector2D subtract(AbstractVector2D abstractVector2D) {
        this.setX(this.getX() - abstractVector2D.getX());
        this.setY(this.getY() - abstractVector2D.getY());
        return this;
    }

    public MutableVector2D rotate(double d) {
        double d2 = this.magnitude();
        double d3 = this.getAngle();
        double d4 = d3 + d;
        double d5 = d2 * Math.cos(d4);
        double d6 = d2 * Math.sin(d4);
        this.setComponents(d5, d6);
        return this;
    }

    public double getY() {
        return this.y;
    }

    public double getX() {
        return this.x;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof MutableVector2D)) {
            return false;
        }
        MutableVector2D mutableVector2D = (MutableVector2D)object;
        if (!mutableVector2D.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getX(), mutableVector2D.getX()) != 0) {
            return false;
        }
        return Double.compare(this.getY(), mutableVector2D.getY()) == 0;
    }

    public boolean canEqual(Object object) {
        return object instanceof MutableVector2D;
    }

    public int hashCode() {
        int n = 1;
        long l = Double.doubleToLongBits(this.getX());
        long l2 = Double.doubleToLongBits(this.getY());
        n = n * 31 + (int)(l >>> 32 ^ l);
        n = n * 31 + (int)(l2 >>> 32 ^ l2);
        return n;
    }

    public String toString() {
        return "MutableVector2D(x=" + this.getX() + ", y=" + this.getY() + ")";
    }
}

