/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.mechanics;

public class PhysicalVector {
    private double[] scalars;

    protected PhysicalVector(int n) {
        this.scalars = new double[n];
    }

    protected double getScalarAt(int n) {
        return this.scalars[n];
    }

    protected void setScalarAt(int n, double d) {
        this.scalars[n] = d;
    }

    public boolean equals(Object object) {
        boolean bl = true;
        if (this.getClass() != object.getClass()) {
            bl = false;
        } else {
            PhysicalVector physicalVector = (PhysicalVector)object;
            for (int i = 0; bl && i < this.scalars.length; ++i) {
                if (this.scalars[i] == physicalVector.scalars[i]) continue;
                bl = false;
            }
        }
        return bl;
    }

    protected PhysicalVector add(PhysicalVector physicalVector, PhysicalVector physicalVector2) {
        for (int i = 0; i < this.scalars.length; ++i) {
            physicalVector2.scalars[i] = this.scalars[i] + physicalVector.scalars[i];
        }
        return physicalVector2;
    }

    protected PhysicalVector multiply(double d, PhysicalVector physicalVector) {
        for (int i = 0; i < this.scalars.length; ++i) {
            physicalVector.scalars[i] = this.scalars[i] * d;
        }
        return physicalVector;
    }

    public double dot(PhysicalVector physicalVector) {
        double d = 0.0;
        for (int i = 0; i < this.scalars.length; ++i) {
            d += this.scalars[i] * physicalVector.scalars[i];
        }
        return d;
    }
}

