/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.view.game;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.reactantsproductsandleftovers.RPALStrings;
import edu.colorado.phet.reactantsproductsandleftovers.module.game.GameModel;
import edu.umd.cs.piccolo.nodes.PText;
import java.awt.Color;
import java.text.MessageFormat;

public class ReactionNumberLabelNode
extends PText {
    private static final String PATTERN = RPALStrings.LABEL_REACTION_NUMBER;
    private static final PhetFont FONT = new PhetFont(20);
    private static final Color COLOR = Color.BLACK;

    public ReactionNumberLabelNode(final GameModel gameModel) {
        this.setFont(FONT);
        this.setTextPaint(COLOR);
        this.setNumber(gameModel.getChallengeNumber());
        gameModel.addGameListener(new GameModel.GameAdapter(){

            public void challengeChanged() {
                ReactionNumberLabelNode.this.setNumber(gameModel.getChallengeNumber() + 1);
            }
        });
    }

    private void setNumber(int n) {
        this.setText(MessageFormat.format(PATTERN, new Integer(n), new Integer(GameModel.getChallengesPerGame())));
    }
}

