/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.view.game;

import edu.colorado.phet.common.phetcommon.util.DefaultDecimalFormat;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.nodes.ShadowPText;
import edu.colorado.phet.reactantsproductsandleftovers.module.game.GameModel;
import java.awt.Color;
import java.awt.Font;
import java.text.NumberFormat;

public class PointsDeltaNode
extends ShadowPText {
    private static final NumberFormat POINTS_FORMAT = new DefaultDecimalFormat("0.#");
    private static final Font FONT = new PhetFont(40);
    private static final Color COLOR = Color.YELLOW;
    private static final Color SHADOW_COLOR = Color.BLACK;
    private double points;

    public PointsDeltaNode(final GameModel gameModel) {
        this.setShadowColor(SHADOW_COLOR);
        this.setShadowOffset(2.0, 2.0);
        this.setFont(FONT);
        this.setTextPaint(COLOR);
        this.setText("?");
        gameModel.addGameListener(new GameModel.GameAdapter(){

            public void pointsChanged() {
                double d = gameModel.getPoints() - PointsDeltaNode.this.points;
                PointsDeltaNode.this.setValue(d);
                PointsDeltaNode.this.points = gameModel.getPoints();
            }
        });
    }

    private void setValue(double d) {
        String string = "0";
        string = d > 0.0 ? "+" + POINTS_FORMAT.format(d) : POINTS_FORMAT.format(d);
        this.setText(string);
    }
}

