/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.view.game;

import edu.umd.cs.piccolo.PNode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeVisibilityManager {
    private final List<PNode> managedNodes;
    private final HashMap<String, List<PNode>> visibleNodesMap;

    public NodeVisibilityManager(PNode[] pNodeArray) {
        this.managedNodes = Arrays.asList(pNodeArray);
        this.visibleNodesMap = new HashMap();
    }

    public void add(String string, PNode ... pNodeArray) {
        if (this.exists(string)) {
            throw new IllegalArgumentException("a collection already exists named " + string);
        }
        for (PNode pNode : pNodeArray) {
            if (this.managedNodes.contains(pNode)) continue;
            throw new IllegalArgumentException("attempt to add an unmanaged node, were all nodes specified in the constructor?");
        }
        this.visibleNodesMap.put(string, Arrays.asList(pNodeArray));
    }

    public void setVisibility(String string) {
        if (!this.exists(string)) {
            throw new IllegalArgumentException("there is no collection named " + string);
        }
        this.setVisible(this.managedNodes, false);
        this.setVisible(this.visibleNodesMap.get(string), true);
    }

    private void setVisible(List<PNode> list, boolean bl) {
        if (list != null) {
            for (PNode pNode : list) {
                pNode.setVisible(bl);
            }
        }
    }

    private boolean exists(String string) {
        Set<String> set = this.visibleNodesMap.keySet();
        return set.contains(string);
    }
}

