/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.piccolophet.PhetPCanvas;
import edu.colorado.phet.common.piccolophet.util.PNodeLayoutUtils;
import edu.colorado.phet.reactantsproductsandleftovers.RPALColors;
import edu.colorado.phet.reactantsproductsandleftovers.RPALConstants;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.geom.Dimension2D;

public class RPALCanvas
extends PhetPCanvas {
    private PNode rootNode;

    public RPALCanvas() {
        super(RPALConstants.CANVAS_RENDERING_SIZE);
        RPALColors.COLOR_SCHEME.addObserver(new SimpleObserver(){

            public void update() {
                RPALCanvas.this.setBackground(RPALColors.COLOR_SCHEME.get().canvasBackground);
            }
        });
        this.rootNode = new PNode();
        this.addWorldChild(this.rootNode);
    }

    protected void addChild(PNode pNode) {
        this.rootNode.addChild(pNode);
    }

    protected void removeChild(PNode pNode) {
        if (pNode != null && this.rootNode.indexOfChild(pNode) != -1) {
            this.rootNode.removeChild(pNode);
        }
    }

    protected void centerRootNode() {
        this.centerNode(this.rootNode);
    }

    protected void centerNode(PNode pNode) {
        if (pNode != null) {
            Dimension2D dimension2D = this.getWorldSize();
            PBounds pBounds = pNode.getFullBoundsReference();
            double d = (dimension2D.getWidth() - pBounds.getWidth() - PNodeLayoutUtils.getOriginXOffset(pNode)) / 2.0;
            double d2 = (dimension2D.getHeight() - pBounds.getHeight() - PNodeLayoutUtils.getOriginYOffset(pNode)) / 2.0;
            pNode.setOffset(d, d2);
        }
    }

    protected void updateLayout() {
        Dimension2D dimension2D = this.getWorldSize();
        if (dimension2D.getWidth() > 0.0 && dimension2D.getHeight() > 0.0) {
            this.centerRootNode();
        }
    }
}

