/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.view;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolox.nodes.PComposite;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class BracketedLabelNode
extends PComposite {
    private final BracketNode bracketNode;
    private final PText textNode;

    public BracketedLabelNode(String string, double d, PhetFont phetFont, Color color, Color color2, Stroke stroke) {
        this.bracketNode = new BracketNode(d, color2, stroke);
        this.addChild(this.bracketNode);
        this.textNode = new PText(string);
        this.textNode.setFont(phetFont);
        this.textNode.setTextPaint(color);
        this.addChild(this.textNode);
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("fullBounds")) {
                    BracketedLabelNode.this.updateLayout();
                }
            }
        });
        this.updateLayout();
    }

    private void updateLayout() {
        double d = 0.0;
        double d2 = 0.0;
        this.bracketNode.setOffset(d, d2);
        d = this.bracketNode.getFullBoundsReference().getCenterX() - this.textNode.getFullBounds().getWidth() / 2.0;
        d2 = this.bracketNode.getFullBoundsReference().getMaxY() + 2.0;
        this.textNode.setOffset(d, d2);
    }

    public void setBracketStrokePaint(Paint paint) {
        this.bracketNode.setStrokePaint(paint);
    }

    private static class BracketNode
    extends PPath {
        public BracketNode(double d, Paint paint, Stroke stroke) {
            this.setStroke(stroke);
            this.setStrokePaint(paint);
            GeneralPath generalPath = new GeneralPath();
            generalPath.moveTo(0.0f, 0.0f);
            generalPath.lineTo(0.0f, 5.0f);
            generalPath.lineTo((float)((d - 6.0) / 2.0), 5.0f);
            generalPath.lineTo((float)(d / 2.0), 11.0f);
            generalPath.lineTo((float)((d + 6.0) / 2.0), 5.0f);
            generalPath.lineTo((float)d, 5.0f);
            generalPath.lineTo((float)d, 0.0f);
            this.setPathTo(generalPath);
        }
    }
}

