/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.view;

import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponent;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentChain;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.reactantsproductsandleftovers.RPALColors;
import edu.colorado.phet.reactantsproductsandleftovers.RPALSimSharing;
import edu.colorado.phet.reactantsproductsandleftovers.RPALStrings;
import edu.colorado.phet.reactantsproductsandleftovers.controls.LeftoversValueNode;
import edu.colorado.phet.reactantsproductsandleftovers.controls.QuantityValueNode;
import edu.colorado.phet.reactantsproductsandleftovers.model.ChemicalReaction;
import edu.colorado.phet.reactantsproductsandleftovers.model.Product;
import edu.colorado.phet.reactantsproductsandleftovers.model.Reactant;
import edu.colorado.phet.reactantsproductsandleftovers.model.Substance;
import edu.colorado.phet.reactantsproductsandleftovers.view.BracketedLabelNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.ImageLayoutNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.SubstanceImageNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.TitledBoxNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAfterNode
extends PhetPNode {
    private static final PhetFont BRACKET_FONT = new PhetFont(16);
    private static final Color BRACKET_TEXT_COLOR = Color.BLACK;
    private static final Color BRACKET_COLOR = RPALColors.COLOR_SCHEME.get().bracketColor;
    private static final Stroke BRACKET_STROKE = new BasicStroke(0.75f);
    private final ChemicalReaction reaction;
    private final ChangeListener reactionChangeListener;
    private final TitledBoxNode titledBoxNode;
    private final ArrayList<ArrayList<SubstanceImageNode>> productImageNodeLists;
    private final ArrayList<ArrayList<SubstanceImageNode>> leftoverImageNodeLists;
    private final ArrayList<QuantityValueNode> productValueNodes;
    private final ArrayList<LeftoversValueNode> leftoverValueNodes;
    private final ImageLayoutNode imageLayoutNode;
    private final BracketedLabelNode productsLabelNode;
    private final BracketedLabelNode leftoversLabelNode;

    public AbstractAfterNode(String string, PDimension pDimension, ChemicalReaction chemicalReaction, IntegerRange integerRange, boolean bl, ImageLayoutNode imageLayoutNode) {
        int n;
        Object object;
        this.reaction = chemicalReaction;
        this.reactionChangeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                AbstractAfterNode.this.update();
            }
        };
        chemicalReaction.addChangeListener(this.reactionChangeListener);
        this.imageLayoutNode = imageLayoutNode;
        this.productImageNodeLists = new ArrayList();
        this.leftoverImageNodeLists = new ArrayList();
        this.productValueNodes = new ArrayList();
        this.leftoverValueNodes = new ArrayList();
        this.titledBoxNode = new TitledBoxNode(string, pDimension);
        this.addChild(this.titledBoxNode);
        this.addChild(imageLayoutNode);
        Product[] productArray = chemicalReaction.getProducts();
        Substance[] substanceArray = productArray;
        int n2 = substanceArray.length;
        for (int i = 0; i < n2; ++i) {
            Product product = substanceArray[i];
            this.productImageNodeLists.add(new ArrayList());
            UserComponentChain object2 = UserComponentChain.chain(RPALSimSharing.UserComponents.productSpinner, new UserComponent(product.getPlainTextName()));
            object = new QuantityValueNode(object2, product, integerRange, 1.0, bl);
            this.addChild((PNode)object);
            this.productValueNodes.add((QuantityValueNode)object);
        }
        for (Substance substance : substanceArray = chemicalReaction.getReactants()) {
            this.leftoverImageNodeLists.add(new ArrayList());
            object = UserComponentChain.chain(RPALSimSharing.UserComponents.leftoverSpinner, new UserComponent(substance.getPlainTextName()));
            LeftoversValueNode leftoversValueNode = new LeftoversValueNode((IUserComponent)object, (Reactant)substance, integerRange, 1.0, bl);
            this.addChild(leftoversValueNode);
            this.leftoverValueNodes.add(leftoversValueNode);
        }
        double d = 0.0;
        double d2 = 0.0;
        this.titledBoxNode.setOffset(d, d2);
        double d3 = this.titledBoxNode.getBoxNode().getFullBoundsReference().getWidth() / (double)(productArray.length + substanceArray.length);
        d = this.titledBoxNode.getBoxNode().getFullBoundsReference().getMinX() + d3 / 2.0;
        d2 = this.titledBoxNode.getBoxNode().getFullBoundsReference().getMaxY() + 15.0;
        for (n = 0; n < productArray.length; ++n) {
            this.productValueNodes.get(n).setOffset(d, d2);
            d += d3;
        }
        for (n = 0; n < substanceArray.length; ++n) {
            this.leftoverValueNodes.get(n).setOffset(d, d2);
            d += d3;
        }
        double d4 = this.productValueNodes.get(0).getFullBoundsReference().getMinX();
        double d5 = this.productValueNodes.get(this.productValueNodes.size() - 1).getFullBoundsReference().getMaxX();
        double d6 = Math.max(95.0, d5 - d4);
        this.productsLabelNode = new BracketedLabelNode(RPALStrings.LABEL_PRODUCTS, d6, BRACKET_FONT, BRACKET_TEXT_COLOR, BRACKET_COLOR, BRACKET_STROKE);
        this.addChild(this.productsLabelNode);
        d = d4 + (d5 - d4 - d6) / 2.0;
        d2 = 0.0;
        this.productsLabelNode.setOffset(d, d2);
        d4 = this.leftoverValueNodes.get(0).getFullBoundsReference().getMinX();
        d5 = this.leftoverValueNodes.get(this.leftoverValueNodes.size() - 1).getFullBoundsReference().getMaxX();
        d6 = d5 - d4;
        this.leftoversLabelNode = new BracketedLabelNode(RPALStrings.LABEL_LEFTOVERS, d6, BRACKET_FONT, BRACKET_TEXT_COLOR, BRACKET_COLOR, BRACKET_STROKE);
        this.addChild(this.leftoversLabelNode);
        d = d4;
        d2 = 0.0;
        for (LeftoversValueNode leftoversValueNode : this.leftoverValueNodes) {
            d2 = Math.max(d2, leftoversValueNode.getFullBoundsReference().getMaxY() + 3.0);
        }
        this.leftoversLabelNode.setOffset(d, d2);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("fullBounds")) {
                    AbstractAfterNode.this.updateProductsLabelOffset();
                }
            }
        };
        for (QuantityValueNode quantityValueNode : this.productValueNodes) {
            quantityValueNode.addPropertyChangeListener(propertyChangeListener);
        }
        this.updateProductsLabelOffset();
        RPALColors.COLOR_SCHEME.addObserver(new SimpleObserver(){

            public void update() {
                AbstractAfterNode.this.productsLabelNode.setBracketStrokePaint(RPALColors.COLOR_SCHEME.get().bracketColor);
                AbstractAfterNode.this.leftoversLabelNode.setBracketStrokePaint(RPALColors.COLOR_SCHEME.get().bracketColor);
            }
        });
        this.update();
    }

    public void cleanup() {
        this.reaction.removeChangeListener(this.reactionChangeListener);
        for (QuantityValueNode cloneable : this.productValueNodes) {
            cloneable.cleanup();
        }
        for (LeftoversValueNode leftoversValueNode : this.leftoverValueNodes) {
            leftoversValueNode.cleanup();
        }
        for (ArrayList arrayList : this.productImageNodeLists) {
            for (SubstanceImageNode substanceImageNode : arrayList) {
                substanceImageNode.cleanup();
            }
        }
        for (ArrayList arrayList : this.leftoverImageNodeLists) {
            for (SubstanceImageNode substanceImageNode : arrayList) {
                substanceImageNode.cleanup();
            }
        }
    }

    protected void setReactionImagesVisible(boolean bl) {
        this.imageLayoutNode.setVisible(bl);
    }

    protected void setValueNodeImagesVisible(boolean bl) {
        for (QuantityValueNode valueNode : this.productValueNodes) {
            valueNode.setImageVisible(bl);
        }
        for (LeftoversValueNode leftoversValueNode : this.leftoverValueNodes) {
            leftoversValueNode.setImageVisible(bl);
        }
    }

    protected void setNumbersVisible(boolean bl) {
        for (QuantityValueNode valueNode : this.productValueNodes) {
            valueNode.setValueVisible(bl);
            valueNode.setHistogramBarVisible(bl);
        }
        for (LeftoversValueNode leftoversValueNode : this.leftoverValueNodes) {
            leftoversValueNode.setValueVisible(bl);
            leftoversValueNode.setHistogramBarVisible(bl);
        }
    }

    protected ArrayList<QuantityValueNode> getProductValueNodes() {
        return this.productValueNodes;
    }

    protected ArrayList<LeftoversValueNode> getLeftoverValueNodes() {
        return this.leftoverValueNodes;
    }

    private void update() {
        SubstanceImageNode substanceImageNode;
        int n;
        ArrayList<SubstanceImageNode> arrayList;
        Object object;
        for (QuantityValueNode quantityValueNode : this.productValueNodes) {
            quantityValueNode.setVisible(this.reaction.isReaction());
        }
        Product[] productArray = this.reaction.getProducts();
        for (int i = 0; i < productArray.length; ++i) {
            Product product = productArray[i];
            object = this.productImageNodeLists.get(i);
            while (product.getQuantity() < ((ArrayList)object).size()) {
                arrayList = (SubstanceImageNode)((ArrayList)object).get(((ArrayList)object).size() - 1);
                ((SubstanceImageNode)((Object)arrayList)).cleanup();
                this.imageLayoutNode.removeNode((SubstanceImageNode)((Object)arrayList));
                ((ArrayList)object).remove(arrayList);
            }
        }
        Reactant[] reactantArray = this.reaction.getReactants();
        for (n = 0; n < reactantArray.length; ++n) {
            object = reactantArray[n];
            arrayList = this.leftoverImageNodeLists.get(n);
            while (((Reactant)object).getLeftovers() < arrayList.size()) {
                substanceImageNode = (SubstanceImageNode)arrayList.get(arrayList.size() - 1);
                substanceImageNode.cleanup();
                this.imageLayoutNode.removeNode(substanceImageNode);
                arrayList.remove(substanceImageNode);
            }
        }
        for (n = 0; n < productArray.length; ++n) {
            object = this.productImageNodeLists.get(n);
            arrayList = productArray[n];
            while (((Substance)((Object)arrayList)).getQuantity() > ((ArrayList)object).size()) {
                substanceImageNode = new SubstanceImageNode((Substance)((Object)arrayList));
                substanceImageNode.scale(1.0);
                ((ArrayList)object).add(substanceImageNode);
                this.imageLayoutNode.addNode(substanceImageNode, this.productValueNodes.get(n));
            }
        }
        for (n = 0; n < reactantArray.length; ++n) {
            object = reactantArray[n];
            arrayList = this.leftoverImageNodeLists.get(n);
            while (((Reactant)object).getLeftovers() > arrayList.size()) {
                substanceImageNode = new SubstanceImageNode((Substance)object);
                substanceImageNode.scale(1.0);
                arrayList.add(substanceImageNode);
                this.imageLayoutNode.addNode(substanceImageNode, this.leftoverValueNodes.get(n));
            }
        }
    }

    private void updateProductsLabelOffset() {
        double d = this.productsLabelNode.getXOffset();
        double d2 = this.leftoversLabelNode.getYOffset();
        for (QuantityValueNode quantityValueNode : this.productValueNodes) {
            d2 = Math.max(d2, quantityValueNode.getFullBoundsReference().getMaxY() + 3.0);
        }
        this.productsLabelNode.setOffset(d, d2);
    }
}

