/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.module.sandwichshop;

import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.view.ResetAllButton;
import edu.colorado.phet.reactantsproductsandleftovers.RPALConstants;
import edu.colorado.phet.reactantsproductsandleftovers.module.sandwichshop.SandwichChoiceNode;
import edu.colorado.phet.reactantsproductsandleftovers.module.sandwichshop.SandwichShopModel;
import edu.colorado.phet.reactantsproductsandleftovers.view.RPALCanvas;
import edu.colorado.phet.reactantsproductsandleftovers.view.RightArrowNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.sandwich.SandwichEquationNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.sandwich.SandwichShopAfterNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.sandwich.SandwichShopBeforeNode;
import edu.umd.cs.piccolo.util.PDimension;
import edu.umd.cs.piccolox.pswing.PSwing;
import java.awt.Component;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SandwichShopCanvas
extends RPALCanvas {
    private static final PDimension BOX_SIZE = RPALConstants.BEFORE_AFTER_BOX_SIZE;
    private final SandwichShopModel model;
    private final SandwichChoiceNode sandwichChoiceNode;
    private final RightArrowNode arrowNode;
    private final PSwing resetAllButtonWrapper;
    private SandwichEquationNode equationNode;
    private SandwichShopBeforeNode beforeNode;
    private SandwichShopAfterNode afterNode;

    public SandwichShopCanvas(SandwichShopModel sandwichShopModel, Resettable resettable) {
        this.model = sandwichShopModel;
        this.sandwichChoiceNode = new SandwichChoiceNode(sandwichShopModel);
        this.sandwichChoiceNode.scale(1.25);
        this.addChild(this.sandwichChoiceNode);
        this.arrowNode = new RightArrowNode();
        this.addChild(this.arrowNode);
        ResetAllButton resetAllButton = new ResetAllButton(resettable, (Component)this);
        this.resetAllButtonWrapper = new PSwing(resetAllButton);
        this.resetAllButtonWrapper.scale(1.25);
        this.addChild(this.resetAllButtonWrapper);
        sandwichShopModel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                SandwichShopCanvas.this.updateDynamicNodes();
            }
        });
        this.updateDynamicNodes();
    }

    private void updateDynamicNodes() {
        if (this.equationNode != null) {
            this.removeChild(this.equationNode);
            this.equationNode.cleanup();
        }
        this.equationNode = new SandwichEquationNode(this.model);
        this.addChild(this.equationNode);
        if (this.beforeNode != null) {
            this.removeChild(this.beforeNode);
            this.beforeNode.cleanup();
        }
        this.beforeNode = new SandwichShopBeforeNode(this.model, BOX_SIZE);
        this.addChild(this.beforeNode);
        if (this.afterNode != null) {
            this.removeChild(this.afterNode);
            this.afterNode.cleanup();
        }
        this.afterNode = new SandwichShopAfterNode(this.model, BOX_SIZE);
        this.addChild(this.afterNode);
        this.updateNodesLayout();
    }

    private void updateNodesLayout() {
        double d = 0.0;
        double d2 = 0.0;
        this.sandwichChoiceNode.setOffset(d, d2);
        d = this.sandwichChoiceNode.getFullBoundsReference().getMinX();
        d2 = this.sandwichChoiceNode.getFullBoundsReference().getMaxY() + 20.0;
        this.equationNode.setOffset(d, d2);
        d = this.equationNode.getFullBoundsReference().getMinX();
        d2 = 180.0;
        this.beforeNode.setOffset(d, d2);
        d = this.beforeNode.getFullBoundsReference().getMaxX() + 20.0;
        d2 = this.beforeNode.getYOffset() + BOX_SIZE.getHeight() / 2.0;
        this.arrowNode.setOffset(d, d2);
        d = this.arrowNode.getFullBoundsReference().getMaxX() + 20.0;
        d2 = this.beforeNode.getYOffset();
        this.afterNode.setOffset(d, d2);
        d = this.arrowNode.getFullBoundsReference().getMaxX() - this.resetAllButtonWrapper.getFullBoundsReference().getWidth();
        d2 = this.afterNode.getFullBoundsReference().getMaxY();
        this.resetAllButtonWrapper.setOffset(d, d2);
    }
}

