/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.module.realreaction;

import edu.colorado.phet.common.phetcommon.simsharing.SimSharingConfig;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.reactantsproductsandleftovers.model.ChemicalReaction;
import edu.colorado.phet.reactantsproductsandleftovers.model.OneProductReactions;
import edu.colorado.phet.reactantsproductsandleftovers.model.RPALModel;
import edu.colorado.phet.reactantsproductsandleftovers.model.Reactant;
import edu.colorado.phet.reactantsproductsandleftovers.model.TwoProductReactions;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class RealReactionModel
extends RPALModel {
    private final EventListenerList listeners;
    private final ChemicalReaction[] reactions = new ChemicalReaction[]{new OneProductReactions.WaterReaction(), new OneProductReactions.AmmoniaReaction(), new TwoProductReactions.MethaneReaction()};
    private ChemicalReaction reaction = this.defaultReaction = SimSharingManager.usingConfig(SimSharingConfig.RPAL_APRIL_2012) ? this.reactions[1] : this.reactions[0];
    private final ChemicalReaction defaultReaction;

    public RealReactionModel() {
        this.listeners = new EventListenerList();
    }

    public void reset() {
        for (ChemicalReaction chemicalReaction : this.reactions) {
            for (Reactant reactant : chemicalReaction.getReactants()) {
                reactant.setQuantity(RealReactionModel.getQuantityRange().getDefault());
            }
        }
        this.setReaction(this.defaultReaction);
    }

    public ChemicalReaction[] getReactions() {
        return this.reactions;
    }

    public void setReaction(ChemicalReaction chemicalReaction) {
        this.reaction = chemicalReaction;
        this.fireStateChanged();
    }

    public ChemicalReaction getReaction() {
        return this.reaction;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(ChangeListener.class, changeListener);
    }

    private void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : (ChangeListener[])this.listeners.getListeners(ChangeListener.class)) {
            changeListener.stateChanged(changeEvent);
        }
    }
}

