/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.module.game;

import edu.colorado.phet.common.phetcommon.model.clock.ClockAdapter;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

class GameTimer {
    private final IClock clock;
    private final EventListenerList listeners;
    private long startTime;
    private long time;

    public GameTimer(IClock iClock) {
        this.clock = iClock;
        iClock.addClockListener(new ClockAdapter(){

            public void clockTicked(ClockEvent clockEvent) {
                GameTimer.this.setTime(clockEvent.getWallTime() - GameTimer.this.startTime);
            }
        });
        this.listeners = new EventListenerList();
    }

    public void start() {
        this.setTime(0L);
        this.startTime = System.currentTimeMillis();
        this.clock.start();
    }

    public void stop() {
        this.clock.pause();
    }

    public long getTime() {
        return this.time;
    }

    private void setTime(long l) {
        this.time = l;
        this.fireTimeChanged();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(ChangeListener.class, changeListener);
    }

    private void fireTimeChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : (ChangeListener[])this.listeners.getListeners(ChangeListener.class)) {
            changeListener.stateChanged(changeEvent);
        }
    }
}

