/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.module.game;

import edu.colorado.phet.common.games.GameSimSharing;
import edu.colorado.phet.common.phetcommon.model.clock.IClock;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ModelComponentTypes;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.reactantsproductsandleftovers.RPALSimSharing;
import edu.colorado.phet.reactantsproductsandleftovers.model.RPALModel;
import edu.colorado.phet.reactantsproductsandleftovers.module.game.GameChallenge;
import edu.colorado.phet.reactantsproductsandleftovers.module.game.GameTimer;
import edu.colorado.phet.reactantsproductsandleftovers.module.game.IChallengeFactory;
import edu.colorado.phet.reactantsproductsandleftovers.module.game.NumberOfVariablesChallengeFactory;
import edu.colorado.phet.reactantsproductsandleftovers.module.game.RPALGameSettings;
import java.util.EventListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class GameModel
extends RPALModel {
    private static final GameChallenge.ChallengeVisibility DEFAULT_CHALLENGE_VISIBILITY = GameChallenge.ChallengeVisibility.BOTH;
    public static final IntegerRange LEVEL_RANGE = new IntegerRange(1, 3, 1);
    private final EventListenerList listeners;
    private final GameTimer timer;
    private final ChangeListener guessChangeListener;
    private final IChallengeFactory challengeFactory;
    private GameChallenge[] challenges;
    private GameChallenge challenge;
    private int challengeNumber;
    private int attempts;
    private double points;
    private final long[] bestTimes;
    private boolean isNewBestTime;
    private boolean gameCompleted;
    private final RPALGameSettings gameSettings = new RPALGameSettings(LEVEL_RANGE, true, true, DEFAULT_CHALLENGE_VISIBILITY);

    public GameModel(IClock iClock) {
        this.listeners = new EventListenerList();
        this.bestTimes = new long[this.gameSettings.getNumberOfLevels()];
        for (int i = 0; i < this.bestTimes.length; ++i) {
            this.bestTimes[i] = 0L;
        }
        this.isNewBestTime = false;
        this.timer = new GameTimer(iClock);
        this.timer.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                if (GameModel.this.isTimerVisible()) {
                    GameModel.this.fireTimeChanged();
                }
            }
        });
        this.guessChangeListener = new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                GameModel.this.fireGuessChanged();
            }
        };
        this.challengeFactory = new NumberOfVariablesChallengeFactory();
        this.gameSettings.level.addObserver(new SimpleObserver(){

            public void update() {
                GameModel.this.fireLevelChanged();
            }
        });
        this.gameSettings.timerEnabled.addObserver(new SimpleObserver(){

            public void update() {
                GameModel.this.fireTimerVisibleChanged();
            }
        });
        this.gameSettings.soundEnabled.addObserver(new SimpleObserver(){

            public void update() {
                GameModel.this.fireSoundEnabledChanged();
            }
        });
        this.gameSettings.challengeVisibility.addObserver(new SimpleObserver(){

            public void update() {
                GameModel.this.fireChallengeVisibilityChanged();
            }
        });
        this.initGame();
        this.setChallenge(0, false);
    }

    public void newGame() {
        if (!this.gameCompleted) {
            this.fireGameAborted();
        }
        this.timer.stop();
        this.recordBestTime();
        this.fireNewGame();
    }

    public void startGame() {
        this.initGame();
        this.setChallenge(0, true);
        this.timer.start();
        this.fireGameStarted();
    }

    private void initGame() {
        this.challenges = this.challengeFactory.createChallenges(5, this.getLevel(), GameModel.getQuantityRange().getMax(), this.getChallengeVisibility());
        this.gameCompleted = false;
        this.isNewBestTime = false;
        this.setPoints(0.0);
    }

    public void nextChallenge() {
        if (this.isLastChallenge()) {
            this.gameCompleted = true;
            this.fireGameCompleted();
        } else {
            this.setChallenge(this.challengeNumber + 1, true);
        }
    }

    public boolean checkGuess() {
        boolean bl = false;
        ++this.attempts;
        if (this.getChallenge().isCorrect()) {
            bl = true;
            if (this.getAttempts() == 1) {
                this.setPoints(this.getPoints() + 2.0);
            } else if (this.getAttempts() == 2) {
                this.setPoints(this.getPoints() + 1.0);
            }
        }
        if (bl && this.isLastChallenge()) {
            this.timer.stop();
            this.recordBestTime();
        }
        return bl;
    }

    private void recordBestTime() {
        if (this.isTimerVisible() && this.isPerfectScore()) {
            long l = this.getTime();
            if (this.getBestTime() == 0L || l < this.getBestTime()) {
                this.setBestTime(l);
                this.isNewBestTime = true;
            }
        }
    }

    private void setChallenge(int n, boolean bl) {
        if (this.challenge != null) {
            this.challenge.getGuess().removeChangeListener(this.guessChangeListener);
        }
        this.attempts = 0;
        this.challengeNumber = n;
        this.challenge = this.challenges[n];
        this.challenge.getGuess().addChangeListener(this.guessChangeListener);
        if (bl) {
            SimSharingManager.sendModelMessage(RPALSimSharing.ModelComponents.gameChallenge, ModelComponentTypes.modelElement, RPALSimSharing.ModelActions.created, ParameterSet.parameterSet((IParameterKey)RPALSimSharing.ParameterKeys.formula, this.challenge.getReaction().getEquationPlainText()).with((IParameterKey)RPALSimSharing.ParameterKeys.quantities, this.challenge.getReaction().getQuantitiesString()));
        }
        this.fireChallengeChanged();
    }

    public static int getChallengesPerGame() {
        return 5;
    }

    public int getChallengeNumber() {
        return this.challengeNumber;
    }

    private boolean isLastChallenge() {
        return this.challengeNumber == GameModel.getChallengesPerGame() - 1;
    }

    public GameChallenge getChallenge() {
        return this.challenge;
    }

    public RPALGameSettings getGameSettings() {
        return this.gameSettings;
    }

    public int getLevel() {
        return (Integer)this.gameSettings.level.get();
    }

    public boolean isTimerVisible() {
        return (Boolean)this.gameSettings.timerEnabled.get();
    }

    public boolean isSoundEnabled() {
        return (Boolean)this.gameSettings.soundEnabled.get();
    }

    public GameChallenge.ChallengeVisibility getChallengeVisibility() {
        return this.gameSettings.challengeVisibility.get();
    }

    public long getTime() {
        return this.timer.getTime();
    }

    public long getBestTime() {
        return this.getBestTime(this.getLevel());
    }

    private void setBestTime(long l) {
        this.setBestTime(this.getLevel(), l);
    }

    private long getBestTime(int n) {
        return this.bestTimes[n - LEVEL_RANGE.getMin()];
    }

    private void setBestTime(int n, long l) {
        this.bestTimes[n - GameModel.LEVEL_RANGE.getMin()] = l;
    }

    public boolean isNewBestTime() {
        return this.isNewBestTime;
    }

    public int getAttempts() {
        return this.attempts;
    }

    private void setPoints(double d) {
        if (d != this.points) {
            this.points = d;
            this.firePointsChanged();
        }
    }

    public double getPoints() {
        return this.points;
    }

    public boolean isPerfectScore() {
        return this.points == GameModel.getPerfectScore();
    }

    public static double getPerfectScore() {
        return (double)GameModel.getChallengesPerGame() * 2.0;
    }

    public void addGameListener(GameListener gameListener) {
        this.listeners.add(GameListener.class, gameListener);
    }

    public void removeGameListener(GameListener gameListener) {
        this.listeners.remove(GameListener.class, gameListener);
    }

    private void fireNewGame() {
        this.firePrintDebug("fireNewGame");
        for (GameListener gameListener : (GameListener[])this.listeners.getListeners(GameListener.class)) {
            gameListener.newGame();
        }
    }

    private void fireGameStarted() {
        this.firePrintDebug("fireGameStarted");
        for (GameListener gameListener : (GameListener[])this.listeners.getListeners(GameListener.class)) {
            gameListener.gameStarted();
        }
    }

    private void fireGameCompleted() {
        this.firePrintDebug("fireGameCompleted");
        for (GameListener gameListener : (GameListener[])this.listeners.getListeners(GameListener.class)) {
            gameListener.gameCompleted();
        }
    }

    private void fireGameAborted() {
        SimSharingManager.sendModelMessage(GameSimSharing.ModelComponents.game, ModelComponentTypes.feature, RPALSimSharing.ModelActions.aborted, ParameterSet.parameterSet((IParameterKey)GameSimSharing.ParameterKeys.score, this.getPoints()));
        this.firePrintDebug("fireGameAborted");
        for (GameListener gameListener : (GameListener[])this.listeners.getListeners(GameListener.class)) {
            gameListener.gameAborted();
        }
    }

    private void fireChallengeChanged() {
        this.firePrintDebug("fireChallengeChanged");
        for (GameListener gameListener : (GameListener[])this.listeners.getListeners(GameListener.class)) {
            gameListener.challengeChanged();
        }
    }

    private void fireGuessChanged() {
        this.firePrintDebug("fireGuessChanged");
        for (GameListener gameListener : (GameListener[])this.listeners.getListeners(GameListener.class)) {
            gameListener.guessChanged();
        }
    }

    private void firePointsChanged() {
        this.firePrintDebug("firePointsChanged");
        for (GameListener gameListener : (GameListener[])this.listeners.getListeners(GameListener.class)) {
            gameListener.pointsChanged();
        }
    }

    private void fireLevelChanged() {
        this.firePrintDebug("fireLevelChanged");
        for (GameListener gameListener : (GameListener[])this.listeners.getListeners(GameListener.class)) {
            gameListener.levelChanged();
        }
    }

    private void fireTimerVisibleChanged() {
        this.firePrintDebug("fireTimerVisibleChanged");
        for (GameListener gameListener : (GameListener[])this.listeners.getListeners(GameListener.class)) {
            gameListener.timerVisibleChanged();
        }
    }

    private void fireSoundEnabledChanged() {
        this.firePrintDebug("fireSoundEnabledChanged");
        for (GameListener gameListener : (GameListener[])this.listeners.getListeners(GameListener.class)) {
            gameListener.soundEnabledChanged();
        }
    }

    private void fireChallengeVisibilityChanged() {
        this.firePrintDebug("fireChallengeVisibilityChanged");
        for (GameListener gameListener : (GameListener[])this.listeners.getListeners(GameListener.class)) {
            gameListener.challengeVisibilityChanged();
        }
    }

    private void fireTimeChanged() {
        for (GameListener gameListener : (GameListener[])this.listeners.getListeners(GameListener.class)) {
            gameListener.timeChanged();
        }
    }

    private void firePrintDebug(String string) {
    }

    public static class GameAdapter
    implements GameListener {
        public void newGame() {
        }

        public void gameStarted() {
        }

        public void gameCompleted() {
        }

        public void gameAborted() {
        }

        public void challengeChanged() {
        }

        public void guessChanged() {
        }

        public void pointsChanged() {
        }

        public void levelChanged() {
        }

        public void timerVisibleChanged() {
        }

        public void soundEnabledChanged() {
        }

        public void challengeVisibilityChanged() {
        }

        public void timeChanged() {
        }
    }

    public static interface GameListener
    extends EventListener {
        public void newGame();

        public void gameStarted();

        public void gameCompleted();

        public void gameAborted();

        public void challengeChanged();

        public void guessChanged();

        public void pointsChanged();

        public void levelChanged();

        public void timerVisibleChanged();

        public void soundEnabledChanged();

        public void challengeVisibilityChanged();

        public void timeChanged();
    }
}

