/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.module.game;

import edu.colorado.phet.reactantsproductsandleftovers.model.ChemicalReaction;
import edu.colorado.phet.reactantsproductsandleftovers.model.Product;
import edu.colorado.phet.reactantsproductsandleftovers.model.Reactant;
import edu.colorado.phet.reactantsproductsandleftovers.module.game.GameChallenge;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class GameGuess {
    private final Reactant[] reactants;
    private final Product[] products;
    private final EventListenerList listeners = new EventListenerList();

    public GameGuess(ChemicalReaction chemicalReaction, GameChallenge.ChallengeType challengeType) {
        Reactant.ReactantChangeAdapter reactantChangeAdapter = new Reactant.ReactantChangeAdapter(){

            public void quantityChanged() {
                GameGuess.this.fireStateChanged();
            }

            public void leftoversChanged() {
                GameGuess.this.fireStateChanged();
            }
        };
        this.reactants = GameGuess.createReactants(chemicalReaction, challengeType, reactantChangeAdapter);
        assert (this.getNumberOfReactants() == chemicalReaction.getNumberOfReactants());
        Product.ProductChangeAdapter productChangeAdapter = new Product.ProductChangeAdapter(){

            public void quantityChanged() {
                GameGuess.this.fireStateChanged();
            }
        };
        this.products = GameGuess.createProducts(chemicalReaction, challengeType, productChangeAdapter);
        assert (this.getNumberOfProducts() == chemicalReaction.getNumberOfProducts());
    }

    public Reactant[] getReactants() {
        return this.reactants;
    }

    public Reactant getReactant(int n) {
        return this.reactants[n];
    }

    public int getNumberOfReactants() {
        return this.reactants.length;
    }

    public Product[] getProducts() {
        return this.products;
    }

    public Product getProduct(int n) {
        return this.products[n];
    }

    public int getNumberOfProducts() {
        return this.products.length;
    }

    private static Reactant[] createReactants(ChemicalReaction chemicalReaction, GameChallenge.ChallengeType challengeType, Reactant.ReactantChangeListener reactantChangeListener) {
        Reactant[] reactantArray = chemicalReaction.getReactants();
        Reactant[] reactantArray2 = new Reactant[reactantArray.length];
        for (int i = 0; i < reactantArray.length; ++i) {
            reactantArray2[i] = Reactant.newInstance(reactantArray[i]);
            if (challengeType == GameChallenge.ChallengeType.AFTER) {
                reactantArray2[i].setLeftovers(0);
            } else {
                reactantArray2[i].setQuantity(0);
            }
            reactantArray2[i].addReactantChangeListener(reactantChangeListener);
        }
        return reactantArray2;
    }

    private static Product[] createProducts(ChemicalReaction chemicalReaction, GameChallenge.ChallengeType challengeType, Product.ProductChangeListener productChangeListener) {
        Product[] productArray = null;
        Product[] productArray2 = chemicalReaction.getProducts();
        productArray = new Product[productArray2.length];
        for (int i = 0; i < productArray2.length; ++i) {
            productArray[i] = Product.newInstance(productArray2[i]);
            if (challengeType == GameChallenge.ChallengeType.AFTER) {
                productArray[i].setQuantity(0);
            }
            productArray[i].addProductChangeListener(productChangeListener);
        }
        return productArray;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(ChangeListener.class, changeListener);
    }

    private void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : (ChangeListener[])this.listeners.getListeners(ChangeListener.class)) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public String toString() {
        int n;
        String string = "";
        for (n = 0; n < this.reactants.length; ++n) {
            if (n != 0) {
                string = string + ",";
            }
            string = string + String.valueOf(this.reactants[n].getQuantity());
        }
        string = string + " -> ";
        for (n = 0; n < this.products.length; ++n) {
            if (n != 0) {
                string = string + ",";
            }
            string = string + String.valueOf(this.products[n].getQuantity());
        }
        for (n = 0; n < this.reactants.length; ++n) {
            string = string + ",";
            string = string + String.valueOf(this.reactants[n].getLeftovers());
        }
        return string;
    }
}

