/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.module.game;

import edu.colorado.phet.common.games.GameAudioPlayer;
import edu.colorado.phet.common.games.GameSimSharing;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.model.Resettable;
import edu.colorado.phet.common.phetcommon.simsharing.messages.IParameterKey;
import edu.colorado.phet.common.phetcommon.simsharing.messages.ParameterSet;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.util.function.Function0;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.FaceNode;
import edu.colorado.phet.common.piccolophet.nodes.HTMLImageButtonNode;
import edu.colorado.phet.common.piccolophet.util.PNodeLayoutUtils;
import edu.colorado.phet.reactantsproductsandleftovers.RPALColors;
import edu.colorado.phet.reactantsproductsandleftovers.RPALConstants;
import edu.colorado.phet.reactantsproductsandleftovers.RPALSimSharing;
import edu.colorado.phet.reactantsproductsandleftovers.RPALStrings;
import edu.colorado.phet.reactantsproductsandleftovers.module.game.GameButtonNode;
import edu.colorado.phet.reactantsproductsandleftovers.module.game.GameChallenge;
import edu.colorado.phet.reactantsproductsandleftovers.module.game.GameModel;
import edu.colorado.phet.reactantsproductsandleftovers.view.RPALCanvas;
import edu.colorado.phet.reactantsproductsandleftovers.view.RightArrowNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.game.DevAnswerNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.game.GameAfterNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.game.GameBeforeNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.game.GameMessageNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.game.GameRewardNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.game.GameSettingsNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.game.NodeVisibilityManager;
import edu.colorado.phet.reactantsproductsandleftovers.view.game.PointsDeltaNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.game.RPALGameOverNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.game.RPALScoreboardNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.game.ReactionNumberLabelNode;
import edu.colorado.phet.reactantsproductsandleftovers.view.realreaction.RealReactionEquationNode;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class GameCanvas
extends RPALCanvas {
    private static final PDimension BOX_SIZE = RPALConstants.BEFORE_AFTER_BOX_SIZE;
    private static final Color FACE_COLOR = new Color(255, 255, 0, 180);
    private final GameModel model;
    private final NodeVisibilityManager visibilityManager;
    private final GameAudioPlayer audioPlayer;
    private final PhetPNode buttonsParentNode;
    private final RPALScoreboardNode scoreboardNode;
    private final RightArrowNode arrowNode;
    private final ReactionNumberLabelNode reactionNumberLabelNode;
    private final PhetPNode parentNode;
    private final PhetPNode gameSettingsNode;
    private final FaceNode faceNode;
    private final HTMLImageButtonNode checkButton;
    private final HTMLImageButtonNode nextButton;
    private final HTMLImageButtonNode tryAgainButton;
    private final HTMLImageButtonNode showAnswerButton;
    private final GameMessageNode instructionsNode;
    private final PointsDeltaNode pointsDeltaNode;
    private final GameRewardNode rewardNode;
    private final DevAnswerNode devAnswerNode;
    private RealReactionEquationNode equationNode;
    private GameBeforeNode beforeNode;
    private GameAfterNode afterNode;
    private RPALGameOverNode gameOverNode;

    public GameCanvas(final GameModel gameModel, Resettable resettable) {
        this.audioPlayer = new GameAudioPlayer(gameModel.isSoundEnabled());
        this.rewardNode = new GameRewardNode();
        this.gameSettingsNode = new GameSettingsNode(gameModel);
        this.gameSettingsNode.scale(1.5);
        this.parentNode = new PhetPNode();
        this.addWorldChild(this.parentNode);
        this.parentNode.moveToBack();
        this.addWorldChild(this.rewardNode);
        this.addWorldChild(this.parentNode);
        this.addWorldChild(this.gameSettingsNode);
        this.arrowNode = new RightArrowNode();
        this.parentNode.addChild(this.arrowNode);
        this.reactionNumberLabelNode = new ReactionNumberLabelNode(gameModel);
        this.parentNode.addChild(this.reactionNumberLabelNode);
        this.scoreboardNode = new RPALScoreboardNode(gameModel);
        this.parentNode.addChild(this.scoreboardNode);
        this.faceNode = new FaceNode(150.0, FACE_COLOR);
        this.parentNode.addChild(this.faceNode);
        this.pointsDeltaNode = new PointsDeltaNode(gameModel);
        this.parentNode.addChild(this.pointsDeltaNode);
        this.buttonsParentNode = new PhetPNode();
        this.parentNode.addChild(this.buttonsParentNode);
        this.checkButton = new GameButtonNode(RPALSimSharing.UserComponents.checkButton, RPALStrings.BUTTON_CHECK){
            {
                super(iUserComponent, string);
                this.setParameters(new Function0<ParameterSet>(){

                    @Override
                    public ParameterSet apply() {
                        return ParameterSet.parameterSet((IParameterKey)GameSimSharing.ParameterKeys.correct, gameModel.getChallenge().isCorrect()).with((IParameterKey)GameSimSharing.ParameterKeys.attempts, gameModel.getAttempts() + 1);
                    }
                });
            }
        };
        this.buttonsParentNode.addChild(this.checkButton);
        this.nextButton = new GameButtonNode(RPALSimSharing.UserComponents.nextButton, RPALStrings.BUTTON_NEXT);
        this.buttonsParentNode.addChild(this.nextButton);
        this.tryAgainButton = new GameButtonNode(RPALSimSharing.UserComponents.tryAgainButton, RPALStrings.BUTTON_TRY_AGAIN);
        this.buttonsParentNode.addChild(this.tryAgainButton);
        this.showAnswerButton = new GameButtonNode(RPALSimSharing.UserComponents.showAnswerButton, RPALStrings.BUTTON_SHOW_ANSWER);
        this.buttonsParentNode.addChild(this.showAnswerButton);
        this.instructionsNode = new GameMessageNode("?", RPALColors.COLOR_SCHEME.get().gameInstructionsColor, 32);
        this.parentNode.addChild(this.instructionsNode);
        RPALColors.COLOR_SCHEME.addObserver(new SimpleObserver(){

            public void update() {
                GameCanvas.this.instructionsNode.setColor(RPALColors.COLOR_SCHEME.get().gameInstructionsColor);
            }
        });
        this.devAnswerNode = new DevAnswerNode(gameModel);
        if (PhetApplication.getInstance().isDeveloperControlsEnabled()) {
            this.parentNode.addChild(this.devAnswerNode);
        }
        this.model = gameModel;
        gameModel.addGameListener(new GameModel.GameAdapter(){

            public void newGame() {
                GameCanvas.this.handleNewGame();
            }

            public void gameStarted() {
                GameCanvas.this.handleGameStarted();
            }

            public void gameCompleted() {
                GameCanvas.this.handleGameCompleted();
            }

            public void gameAborted() {
                GameCanvas.this.handleGameAborted();
            }

            public void challengeChanged() {
                GameCanvas.this.handleChallengeChanged();
            }

            public void guessChanged() {
                GameCanvas.this.handleGuessChanged();
            }

            public void soundEnabledChanged() {
                GameCanvas.this.handleSoundEnabledChanged();
            }
        });
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName() == "visible") {
                    GameCanvas.this.updateButtonsLayout();
                }
            }
        };
        this.checkButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GameCanvas.this.checkButtonPressed();
            }
        });
        this.checkButton.addPropertyChangeListener(propertyChangeListener);
        this.nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GameCanvas.this.nextButtonPressed();
            }
        });
        this.nextButton.addPropertyChangeListener(propertyChangeListener);
        this.tryAgainButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GameCanvas.this.tryAgainButtonPressed();
            }
        });
        this.tryAgainButton.addPropertyChangeListener(propertyChangeListener);
        this.showAnswerButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GameCanvas.this.showAnswerButtonPressed();
            }
        });
        this.showAnswerButton.addPropertyChangeListener(propertyChangeListener);
        PNode[] pNodeArray = new PNode[]{this.parentNode, this.gameSettingsNode, this.faceNode, this.checkButton, this.nextButton, this.tryAgainButton, this.showAnswerButton, this.instructionsNode, this.pointsDeltaNode, this.rewardNode};
        this.visibilityManager = new NodeVisibilityManager(pNodeArray);
        this.visibilityManager.add("gameSetting", this.gameSettingsNode);
        this.visibilityManager.add("firstAttempt", this.parentNode, this.checkButton, this.instructionsNode);
        this.visibilityManager.add("firstAttemptCorrect", this.parentNode, this.faceNode, this.nextButton, this.pointsDeltaNode);
        this.visibilityManager.add("firstAttemptWrong", this.parentNode, this.faceNode, this.tryAgainButton);
        this.visibilityManager.add("secondAttempt", this.parentNode, this.checkButton);
        this.visibilityManager.add("secondAttemptCorrect", this.parentNode, this.faceNode, this.nextButton, this.pointsDeltaNode);
        this.visibilityManager.add("secondAttemptWrong", this.parentNode, this.faceNode, this.showAnswerButton);
        this.visibilityManager.add("answerShown", this.parentNode, this.nextButton);
        this.visibilityManager.add("gameSummary", this.rewardNode);
        this.updateDynamicNodes();
        this.updateButtonsLayout();
        this.visibilityManager.setVisibility("gameSetting");
    }

    public GameRewardNode getRewardNode() {
        return this.rewardNode;
    }

    private void handleNewGame() {
        this.removeGameOverNode();
        this.visibilityManager.setVisibility("gameSetting");
    }

    private void handleGameStarted() {
        this.showGuess(true);
        this.visibilityManager.setVisibility("firstAttempt");
    }

    private void handleGameCompleted() {
        this.addGameOverNode();
        this.rewardNode.setLevel(this.model.getLevel(), this.model.isPerfectScore());
        this.visibilityManager.setVisibility("gameSummary");
        if (this.model.isPerfectScore()) {
            this.audioPlayer.gameOverPerfectScore();
        } else if (this.model.getPoints() == 0.0) {
            this.audioPlayer.gameOverZeroScore();
        } else {
            this.audioPlayer.gameOverImperfectScore();
        }
    }

    private void addGameOverNode() {
        this.gameOverNode = new RPALGameOverNode(this.model);
        this.gameOverNode.scale(1.5);
        this.addWorldChild(this.gameOverNode);
        this.centerNode(this.gameOverNode);
    }

    private void removeGameOverNode() {
        if (this.gameOverNode != null) {
            this.removeWorldChild(this.gameOverNode);
            this.gameOverNode = null;
        }
    }

    private void handleGameAborted() {
        this.visibilityManager.setVisibility("gameSetting");
    }

    private void handleChallengeChanged() {
        this.visibilityManager.setVisibility("firstAttempt");
        this.updateDynamicNodes();
        this.showGuess(true);
    }

    private void handleGuessChanged() {
        this.instructionsNode.setVisible(false);
    }

    private void handleSoundEnabledChanged() {
        this.audioPlayer.setEnabled(this.model.isSoundEnabled());
    }

    private void checkButtonPressed() {
        this.showGuess(false);
        boolean bl = this.model.checkGuess();
        int n = this.model.getAttempts();
        if (bl) {
            this.audioPlayer.correctAnswer();
            this.faceNode.smile();
            if (n == 1) {
                this.visibilityManager.setVisibility("firstAttemptCorrect");
            } else {
                this.visibilityManager.setVisibility("secondAttemptCorrect");
            }
            this.showAnswerForCorrectGuess();
        } else {
            this.audioPlayer.wrongAnswer();
            this.faceNode.frown();
            if (n == 1) {
                this.visibilityManager.setVisibility("firstAttemptWrong");
            } else {
                this.visibilityManager.setVisibility("secondAttemptWrong");
            }
        }
    }

    private void nextButtonPressed() {
        this.model.nextChallenge();
    }

    private void tryAgainButtonPressed() {
        this.showGuess(true);
        this.visibilityManager.setVisibility("secondAttempt");
    }

    private void showAnswerButtonPressed() {
        this.showAnswer();
        this.visibilityManager.setVisibility("answerShown");
    }

    private void showGuess(boolean bl) {
        GameChallenge gameChallenge = this.model.getChallenge();
        if (gameChallenge.getChallengeType() == GameChallenge.ChallengeType.AFTER) {
            this.afterNode.showGuess(bl);
        } else {
            this.beforeNode.showGuess(bl);
        }
    }

    private void showAnswer() {
        this.afterNode.showAnswer();
        this.beforeNode.showAnswer();
    }

    private void showAnswerForCorrectGuess() {
        if (this.model.getChallenge().getChallengeType() == GameChallenge.ChallengeType.AFTER) {
            this.beforeNode.showAnswer();
        } else {
            this.afterNode.showAnswer();
        }
    }

    protected void updateLayout() {
        super.updateLayout();
        Dimension2D dimension2D = this.getWorldSize();
        if (dimension2D.getWidth() > 0.0 && dimension2D.getHeight() > 0.0) {
            PBounds pBounds = new PBounds(0.0, 0.0, dimension2D.getWidth(), dimension2D.getHeight());
            this.rewardNode.setBounds(pBounds);
            this.centerNode(this.gameSettingsNode);
            this.centerNode(this.gameOverNode);
            this.centerNode(this.parentNode);
        }
    }

    private void updateDynamicNodes() {
        if (this.equationNode != null) {
            this.equationNode.cleanup();
            this.parentNode.removeChild(this.equationNode);
        }
        this.equationNode = new RealReactionEquationNode(this.model.getChallenge().getReaction());
        this.parentNode.addChild(this.equationNode);
        if (this.beforeNode != null) {
            this.beforeNode.cleanup();
            this.parentNode.removeChild(this.beforeNode);
        }
        this.beforeNode = new GameBeforeNode(this.model, BOX_SIZE);
        this.parentNode.addChild(this.beforeNode);
        if (this.afterNode != null) {
            this.afterNode.cleanup();
            this.parentNode.removeChild(this.afterNode);
        }
        this.afterNode = new GameAfterNode(this.model, BOX_SIZE);
        this.parentNode.addChild(this.afterNode);
        this.devAnswerNode.moveToFront();
        this.buttonsParentNode.moveToFront();
        this.faceNode.moveToFront();
        this.pointsDeltaNode.moveToFront();
        this.instructionsNode.moveToFront();
        this.updateNodesLayout();
    }

    private void updateNodesLayout() {
        double d = 0.0;
        double d2 = 7.0;
        this.reactionNumberLabelNode.setOffset(d, d2);
        d = this.reactionNumberLabelNode.getFullBoundsReference().getWidth() + 35.0;
        d2 = 0.0;
        this.equationNode.setOffset(d, d2);
        d = this.reactionNumberLabelNode.getFullBoundsReference().getMinX();
        d2 = this.reactionNumberLabelNode.getFullBoundsReference().getMaxY() - PNodeLayoutUtils.getOriginYOffset(this.beforeNode) + 40.0;
        this.beforeNode.setOffset(d, d2);
        d = this.beforeNode.getFullBoundsReference().getMaxX() + 20.0;
        d2 = this.beforeNode.getYOffset() + BOX_SIZE.getHeight() / 2.0;
        this.arrowNode.setOffset(d, d2);
        d = this.arrowNode.getFullBoundsReference().getMaxX() + 20.0;
        d2 = this.beforeNode.getYOffset();
        this.afterNode.setOffset(d, d2);
        this.scoreboardNode.setBackgroundWidth(this.afterNode.getFullBoundsReference().getMaxX() - this.beforeNode.getFullBoundsReference().getMinX());
        d = this.beforeNode.getXOffset();
        d2 = Math.max(this.beforeNode.getFullBoundsReference().getMaxY(), this.afterNode.getFullBoundsReference().getMaxY()) + 20.0;
        this.scoreboardNode.setOffset(d, d2);
        Point2D point2D = null;
        point2D = this.model.getChallenge().getChallengeType() == GameChallenge.ChallengeType.AFTER ? this.afterNode.getOffset() : this.beforeNode.getOffset();
        d = point2D.getX() + (BOX_SIZE.getWidth() - this.faceNode.getFullBoundsReference().getWidth()) / 2.0;
        d2 = point2D.getY() + (BOX_SIZE.getHeight() - this.faceNode.getFullBoundsReference().getHeight()) / 2.0 - 20.0;
        this.faceNode.setOffset(d, d2);
        d = this.faceNode.getFullBoundsReference().getMaxX() + 15.0;
        d2 = this.faceNode.getFullBoundsReference().getCenterY() - this.pointsDeltaNode.getFullBoundsReference().getHeight() / 2.0;
        this.pointsDeltaNode.setOffset(d, d2);
        point2D = null;
        if (this.model.getChallenge().getChallengeType() == GameChallenge.ChallengeType.AFTER) {
            this.instructionsNode.setText(RPALStrings.QUESTION_HOW_MANY_PRODUCTS_AND_LEFTOVERS);
            point2D = this.afterNode.getOffset();
        } else {
            this.instructionsNode.setText(RPALStrings.QUESTION_HOW_MANY_REACTANTS);
            point2D = this.beforeNode.getOffset();
        }
        d = point2D.getX() + (BOX_SIZE.getWidth() - this.instructionsNode.getFullBoundsReference().getWidth()) / 2.0;
        d2 = point2D.getY() + (BOX_SIZE.getHeight() - this.instructionsNode.getFullBoundsReference().getHeight()) / 2.0 - 20.0;
        this.instructionsNode.setOffset(d, d2);
        d = this.scoreboardNode.getFullBoundsReference().getCenterX() - this.devAnswerNode.getFullBoundsReference().getWidth() / 2.0;
        d2 = this.scoreboardNode.getFullBoundsReference().getMaxY() + 2.0;
        this.devAnswerNode.setOffset(d, d2);
        d = this.parentNode.getFullBoundsReference().getCenterX() - this.gameSettingsNode.getFullBoundsReference().getWidth() / 2.0;
        d2 = this.parentNode.getFullBoundsReference().getCenterY() - this.gameSettingsNode.getFullBoundsReference().getHeight() / 2.0;
        this.gameSettingsNode.setOffset(d, d2);
    }

    private void updateButtonsLayout() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < this.buttonsParentNode.getChildrenCount(); ++i) {
            PNode pNode = this.buttonsParentNode.getChild(i);
            if (!pNode.getVisible()) continue;
            pNode.setOffset(d, d2);
            d += pNode.getFullBoundsReference().getWidth() + 20.0;
            d3 = pNode.getFullBoundsReference().getMaxX();
            d4 = pNode.getFullBoundsReference().getMaxY();
        }
        Point2D point2D = null;
        point2D = this.model.getChallenge().getChallengeType() == GameChallenge.ChallengeType.AFTER ? this.afterNode.getOffset() : this.beforeNode.getOffset();
        d = point2D.getX() + (BOX_SIZE.getWidth() - d3) / 2.0;
        d2 = point2D.getY() + BOX_SIZE.getHeight() - d4 - 10.0;
        this.buttonsParentNode.setOffset(d, d2);
    }
}

