/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.model;

import edu.colorado.phet.reactantsproductsandleftovers.model.Product;
import edu.colorado.phet.reactantsproductsandleftovers.model.Reactant;
import edu.colorado.phet.reactantsproductsandleftovers.model.Substance;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class ChemicalReaction {
    private final String name;
    private final String internalName;
    private final Reactant[] reactants;
    private final Product[] products;
    private final EventListenerList listeners;

    public ChemicalReaction(Reactant[] reactantArray, Product[] productArray) {
        this(ChemicalReaction.getEquationHTML(reactantArray, productArray), reactantArray, productArray);
    }

    public ChemicalReaction(String string, Reactant[] reactantArray, Product[] productArray) {
        this(string, string, reactantArray, productArray);
    }

    public ChemicalReaction(String string, String string2, Reactant[] reactantArray, Product[] productArray) {
        if (reactantArray.length < 2) {
            throw new IllegalArgumentException("a reaction requires at least 2 reactants");
        }
        if (productArray.length < 1) {
            throw new IllegalArgumentException("a reaction requires at least 1 product");
        }
        this.name = string;
        this.internalName = string2;
        this.reactants = reactantArray;
        this.products = productArray;
        this.listeners = new EventListenerList();
        Reactant.ReactantChangeAdapter reactantChangeAdapter = new Reactant.ReactantChangeAdapter(){

            public void coefficientChanged() {
                ChemicalReaction.this.update();
            }

            public void quantityChanged() {
                ChemicalReaction.this.update();
            }
        };
        for (Reactant reactant : reactantArray) {
            reactant.addReactantChangeListener(reactantChangeAdapter);
        }
        this.update();
    }

    public String getName() {
        return this.name;
    }

    public String getInternalName() {
        return this.internalName;
    }

    public Reactant[] getReactants() {
        return this.reactants;
    }

    public Reactant getReactant(int n) {
        return this.reactants[n];
    }

    public int getNumberOfReactants() {
        return this.reactants.length;
    }

    public Product[] getProducts() {
        return this.products;
    }

    public Product getProduct(int n) {
        return this.products[n];
    }

    public int getNumberOfProducts() {
        return this.products.length;
    }

    public boolean isReaction() {
        int n = 0;
        int n2 = 0;
        for (Reactant reactant : this.reactants) {
            if (reactant.getCoefficient() > 0) {
                ++n;
            }
            if (reactant.getCoefficient() <= 1) continue;
            ++n2;
        }
        return n > 1 || n2 > 0;
    }

    private void update() {
        int n = this.getNumberOfReactions();
        for (Product substance : this.products) {
            substance.setQuantity(n * substance.getCoefficient());
        }
        for (Substance substance : this.reactants) {
            ((Reactant)substance).setLeftovers(substance.getQuantity() - n * substance.getCoefficient());
        }
        this.fireStateChanged();
    }

    private int getNumberOfReactions() {
        int n = 0;
        if (this.isReaction()) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (Reactant reactant : this.reactants) {
                if (reactant.getCoefficient() == 0) continue;
                arrayList.add(new Integer(reactant.getQuantity() / reactant.getCoefficient()));
            }
            assert (arrayList.size() > 0);
            Collections.sort(arrayList);
            n = (Integer)arrayList.get(0);
        }
        return n;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listeners.remove(ChangeListener.class, changeListener);
    }

    private void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : (ChangeListener[])this.listeners.getListeners(ChangeListener.class)) {
            changeListener.stateChanged(changeEvent);
        }
    }

    public String toString() {
        return this.getEquationPlainText() + " " + this.getQuantitiesString();
    }

    public String getEquationHTML() {
        return ChemicalReaction.getEquationHTML(this.reactants, this.products);
    }

    private static String getEquationHTML(Reactant[] reactantArray, Product[] productArray) {
        int n;
        String string = "";
        for (n = 0; n < reactantArray.length; ++n) {
            if (n != 0) {
                string = string + "+";
            }
            string = string + reactantArray[n].getCoefficient();
            string = string + reactantArray[n].getName();
        }
        string = string + "->";
        for (n = 0; n < productArray.length; ++n) {
            if (n != 0) {
                string = string + "+";
            }
            string = string + productArray[n].getCoefficient();
            string = string + productArray[n].getName();
        }
        return string;
    }

    public String getEquationPlainText() {
        return this.getEquationHTML().replaceAll("<sub>", "").replaceAll("</sub>", "");
    }

    public String getQuantitiesString() {
        int n;
        String string = "";
        for (n = 0; n < this.reactants.length; ++n) {
            if (n != 0) {
                string = string + ",";
            }
            string = string + String.valueOf(this.reactants[n].getQuantity());
        }
        string = string + "->";
        for (n = 0; n < this.products.length; ++n) {
            if (n != 0) {
                string = string + ",";
            }
            string = string + String.valueOf(this.products[n].getQuantity());
        }
        for (n = 0; n < this.reactants.length; ++n) {
            string = string + ",";
            string = string + String.valueOf(this.reactants[n].getLeftovers());
        }
        return string;
    }
}

