/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.controls;

import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.common.phetcommon.view.util.HTMLUtils;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.HTMLNode;
import edu.colorado.phet.common.piccolophet.util.PNodeLayoutUtils;
import edu.colorado.phet.reactantsproductsandleftovers.RPALConstants;
import edu.colorado.phet.reactantsproductsandleftovers.controls.HistogramBarNode;
import edu.colorado.phet.reactantsproductsandleftovers.controls.IntegerSpinnerNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PDimension;
import java.awt.Font;
import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class ValueNode
extends PhetPNode {
    private static final PDimension HISTOGRAM_BAR_SIZE = RPALConstants.HISTOGRAM_BAR_SIZE;
    private static final Font VALUE_FONT = new PhetFont(24);
    private static final Font NAME_FONT = new PhetFont(18);
    private final EventListenerList listeners;
    private final HistogramBarNode barNode;
    private final PImage imageNode;
    private final HTMLNode nameNode;
    private final IntegerSpinnerNode spinnerNode;
    private final PText valueNode;
    private int value;

    public ValueNode(IUserComponent iUserComponent, IntegerRange integerRange, int n, Image image, double d, String string, boolean bl, boolean bl2) {
        if (!integerRange.contains(n)) {
            throw new IllegalArgumentException("value is out of range: " + n);
        }
        this.listeners = new EventListenerList();
        this.barNode = new HistogramBarNode(n, integerRange.getMin(), integerRange.getMax(), HISTOGRAM_BAR_SIZE);
        this.imageNode = new PImage(image);
        this.imageNode.scale(d);
        this.nameNode = new HTMLNode(HTMLUtils.toHTMLString(string));
        this.nameNode.setFont(NAME_FONT);
        this.spinnerNode = new IntegerSpinnerNode(iUserComponent, integerRange);
        this.spinnerNode.scale(1.5);
        this.spinnerNode.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                ValueNode.this.setValue(ValueNode.this.spinnerNode.getValue());
            }
        });
        this.valueNode = new PText();
        this.valueNode.setFont(VALUE_FONT);
        this.addChild(this.barNode);
        this.addChild(this.imageNode);
        if (bl) {
            this.addChild(this.nameNode);
        }
        this.addChild(this.spinnerNode);
        this.addChild(this.valueNode);
        this.barNode.setPickable(false);
        this.imageNode.setPickable(false);
        this.nameNode.setPickable(false);
        this.valueNode.setPickable(false);
        this.imageNode.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("fullBounds")) {
                    ValueNode.this.updateLayout();
                }
            }
        });
        this.valueNode.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("fullBounds")) {
                    ValueNode.this.updateLayout();
                }
            }
        });
        this.updateLayout();
        this.setEditable(bl2);
        this.value = n - 1;
        this.setValue(n);
    }

    public void setValue(int n) {
        if (n != this.value) {
            this.value = n;
            this.barNode.setValue(n);
            this.spinnerNode.setValue(n);
            this.valueNode.setText(String.valueOf(n));
            this.fireStateChanged();
        }
    }

    public int getValue() {
        return this.spinnerNode.getValue();
    }

    public void setEditable(boolean bl) {
        this.spinnerNode.setPickable(bl);
        this.spinnerNode.setEnabled(bl);
        if (bl) {
            this.addChild(this.spinnerNode);
            this.removeChild(this.valueNode);
        } else {
            this.removeChild(this.spinnerNode);
            this.addChild(this.valueNode);
        }
    }

    public void setImage(Image image) {
        this.imageNode.setImage(image);
    }

    public void setValueVisible(boolean bl) {
        this.valueNode.setVisible(bl);
    }

    public void setHistogramBarVisible(boolean bl) {
        this.barNode.setVisible(bl);
    }

    public void setImageVisible(boolean bl) {
        this.imageNode.setVisible(bl);
    }

    private void updateLayout() {
        double d = -(this.barNode.getFullBoundsReference().getWidth() / 2.0);
        double d2 = 0.0;
        this.barNode.setOffset(d, d2);
        d = this.barNode.getFullBoundsReference().getMinX() - this.spinnerNode.getFullBoundsReference().getWidth() - 2.0;
        d2 = HISTOGRAM_BAR_SIZE.getHeight() - this.spinnerNode.getFullBoundsReference().getHeight();
        this.spinnerNode.setOffset(d, d2);
        d = this.barNode.getFullBoundsReference().getMinX() - this.valueNode.getFullBoundsReference().getWidth() - 6.0;
        d2 = this.barNode.getFullBoundsReference().getMaxY() - this.valueNode.getFullBoundsReference().getHeight();
        this.valueNode.setOffset(d, d2);
        d = this.barNode.getFullBoundsReference().getCenterX() - this.imageNode.getFullBoundsReference().getWidth() / 2.0;
        d2 = this.barNode.getFullBoundsReference().getMaxY() - PNodeLayoutUtils.getOriginYOffset(this.imageNode) + 15.0;
        this.imageNode.setOffset(d, d2);
        d = this.imageNode.getFullBoundsReference().getCenterX() - this.nameNode.getFullBoundsReference().getWidth() / 2.0;
        d2 = this.imageNode.getFullBoundsReference().getMaxY() + 3.0;
        this.nameNode.setOffset(d, d2);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listeners.add(ChangeListener.class, changeListener);
    }

    private void fireStateChanged() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : (ChangeListener[])this.listeners.getListeners(ChangeListener.class)) {
            changeListener.stateChanged(changeEvent);
        }
    }
}

