/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.controls;

import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.reactantsproductsandleftovers.controls.ValueNode;
import edu.colorado.phet.reactantsproductsandleftovers.model.Substance;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class QuantityValueNode
extends ValueNode {
    private Substance substance;
    private final Substance.SubstanceChangeListener substanceChangeListener;

    public QuantityValueNode(IUserComponent iUserComponent, Substance substance, IntegerRange integerRange, double d, boolean bl) {
        super(iUserComponent, integerRange, substance.getQuantity(), substance.getImage(), d, substance.getName(), bl, false);
        this.substance = substance;
        this.substanceChangeListener = new Substance.SubstanceChangeAdapter(){

            public void quantityChanged() {
                QuantityValueNode.this.updateQuantity();
            }

            public void imageChanged() {
                QuantityValueNode.this.updateImage();
            }
        };
        substance.addSubstanceChangeListener(this.substanceChangeListener);
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                QuantityValueNode.this.updateModel();
            }
        });
    }

    public void setSubstance(Substance substance) {
        if (substance != this.substance) {
            this.substance.removeSubstanceChangeListener(this.substanceChangeListener);
            this.substance = substance;
            this.updateQuantity();
            this.updateImage();
            this.substance.addSubstanceChangeListener(this.substanceChangeListener);
        }
    }

    public void cleanup() {
        this.substance.removeSubstanceChangeListener(this.substanceChangeListener);
    }

    private void updateQuantity() {
        this.setValue(this.substance.getQuantity());
    }

    private void updateImage() {
        this.setImage(this.substance.getImage());
    }

    private void updateModel() {
        this.substance.setQuantity(this.getValue());
    }
}

