/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.reactantsproductsandleftovers.controls;

import edu.colorado.phet.common.phetcommon.simsharing.messages.IUserComponent;
import edu.colorado.phet.common.phetcommon.util.IntegerRange;
import edu.colorado.phet.common.phetcommon.view.controls.IntegerSpinner;
import edu.colorado.phet.common.piccolophet.event.CursorHandler;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolox.pswing.PSwing;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class IntegerSpinnerNode
extends PNode {
    private final IntegerSpinner spinner;
    private final EventListenerList listeners;

    public IntegerSpinnerNode(IUserComponent iUserComponent, IntegerRange integerRange) {
        this.addInputEventListener(new CursorHandler());
        this.listeners = new EventListenerList();
        this.spinner = new IntegerSpinner(iUserComponent, integerRange);
        this.addChild(new PSwing(this.spinner));
        this.spinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                IntegerSpinnerNode.this.fireStateChange();
            }
        });
    }

    public void setEnabled(boolean bl) {
        this.spinner.setEnabled(bl);
    }

    public void setValue(int n) {
        this.spinner.setIntValue(n);
    }

    public int getValue() {
        return this.spinner.getIntValue();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.spinner.addChangeListener(changeListener);
        this.listeners.add(ChangeListener.class, changeListener);
    }

    private void fireStateChange() {
        ChangeEvent changeEvent = new ChangeEvent(this);
        for (ChangeListener changeListener : (ChangeListener[])this.listeners.getListeners(ChangeListener.class)) {
            changeListener.stateChanged(changeEvent);
        }
    }
}

