/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.games;

import edu.colorado.phet.common.games.GameSimSharing;
import edu.colorado.phet.common.games.GameTimerFormat;
import edu.colorado.phet.common.games.GamesResources;
import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.resources.PhetCommonResources;
import edu.colorado.phet.common.phetcommon.simsharing.SimSharingManager;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserActions;
import edu.colorado.phet.common.phetcommon.simsharing.messages.UserComponentTypes;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.PhetOptionPane;
import edu.colorado.phet.common.piccolophet.PhetPNode;
import edu.colorado.phet.common.piccolophet.nodes.HTMLImageButtonNode;
import edu.umd.cs.piccolo.nodes.PImage;
import edu.umd.cs.piccolo.nodes.PPath;
import edu.umd.cs.piccolo.nodes.PText;
import edu.umd.cs.piccolo.util.PBounds;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.EventListener;
import javax.swing.event.EventListenerList;

public class GameScoreboardNode
extends PhetPNode {
    private static final BufferedImage STOPWATCH_ICON = GamesResources.getImage("blue-stopwatch.png");
    private static final String LABEL_SCORE = PhetCommonResources.getString("Games.label.score");
    private static final String BUTTON_NEW_GAME = PhetCommonResources.getString("Games.button.newGame");
    private static final String LABEL_LEVEL = PhetCommonResources.getString("Games.label.level");
    private static final String LABEL_BEST = PhetCommonResources.getString("Games.label.best");
    private static final String FORMAT_TIME_BEST = PhetCommonResources.getString("Games.format.time.best");
    private static final String MESSAGE_CONFIRM_NEW_GAME = PhetCommonResources.getString("Games.message.confirmNewGame");
    private static final String CONFIRM_TITLE = PhetCommonResources.getString("Common.title.confirm");
    private static final Color BACKGROUND_FILL_COLOR = new Color(180, 205, 255);
    private static final Color BACKGROUND_STROKE_COLOR = Color.BLACK;
    private static final Stroke BACKGROUND_STROKE = new BasicStroke(1.0f);
    private static final Color BUTTON_COLOR = new Color(235, 235, 235);
    private static final PhetFont FONT = new PhetFont(24);
    private static final PhetFont BUTTON_FONT = new PhetFont(1, 18);
    private final NumberFormat pointsFormat;
    private final PText scoreNode;
    private final PText levelNode;
    private final PText timerValue;
    private final PImage timerIcon;
    private final HTMLImageButtonNode newGameButton;
    private final PPath backgroundNode;
    private final Rectangle2D backgroundShape;
    private final EventListenerList listeners;
    private boolean confirmNewGame;

    public GameScoreboardNode(int n, double d, NumberFormat numberFormat) {
        this.pointsFormat = numberFormat;
        this.confirmNewGame = true;
        this.listeners = new EventListenerList();
        this.levelNode = new PText();
        this.levelNode.setFont(FONT);
        this.setLevel(n);
        this.scoreNode = new PText();
        this.scoreNode.setFont(FONT);
        this.setScore(d);
        this.timerIcon = new PImage(STOPWATCH_ICON);
        this.timerValue = new PText();
        this.timerValue.setFont(FONT);
        this.setTime(0L);
        this.newGameButton = new HTMLImageButtonNode(BUTTON_NEW_GAME, BUTTON_FONT, BUTTON_COLOR){
            {
                this.setUserComponent(GameSimSharing.UserComponents.newGameButton);
            }
        };
        this.newGameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                GameScoreboardNode.this.handleNewGame();
            }
        });
        this.addChild(this.levelNode);
        this.addChild(this.scoreNode);
        this.addChild(this.timerIcon);
        this.addChild(this.timerValue);
        this.addChild(this.newGameButton);
        double d2 = this.getMaxChildHeight();
        double d3 = 20.0;
        double d4 = 5.0 + (d2 - this.levelNode.getFullBoundsReference().getHeight()) / 2.0;
        this.levelNode.setOffset(d3, d4);
        d3 = this.levelNode.getFullBoundsReference().getMaxX() + 80.0;
        d4 = 5.0 + (d2 - this.scoreNode.getFullBoundsReference().getHeight()) / 2.0;
        this.scoreNode.setOffset(d3, d4);
        d3 = this.scoreNode.getFullBoundsReference().getMaxX() + 60.0;
        d4 = 5.0 + (d2 - this.timerIcon.getFullBoundsReference().getHeight()) / 2.0;
        this.timerIcon.setOffset(d3, d4);
        d3 = this.timerIcon.getFullBoundsReference().getMaxX() + 5.0;
        d4 = 5.0 + (d2 - this.timerValue.getFullBoundsReference().getHeight()) / 2.0;
        this.timerValue.setOffset(d3, d4);
        d3 = this.timerValue.getFullBoundsReference().getMaxX() + 20.0;
        d4 = 5.0 + (d2 - this.newGameButton.getFullBoundsReference().getHeight()) / 2.0;
        this.newGameButton.setOffset(d3, d4);
        PBounds pBounds = this.getFullBoundsReference();
        this.backgroundShape = new Rectangle2D.Double(0.0, 0.0, pBounds.getMaxX() + 20.0, pBounds.getMaxY() + 5.0);
        this.backgroundNode = new PPath(this.backgroundShape);
        this.backgroundNode.setPaint(BACKGROUND_FILL_COLOR);
        this.backgroundNode.setStroke(BACKGROUND_STROKE);
        this.backgroundNode.setStrokePaint(BACKGROUND_STROKE_COLOR);
        this.addChild(this.backgroundNode);
        this.backgroundNode.moveToBack();
    }

    public void setBackgroundWidth(double d) {
        this.backgroundShape.setRect(this.backgroundShape.getX(), this.backgroundShape.getY(), d, this.backgroundShape.getHeight());
        this.backgroundNode.setPathTo(this.backgroundShape);
        double d2 = this.backgroundNode.getFullBoundsReference().getMaxX() - this.newGameButton.getFullBoundsReference().getWidth() - 20.0;
        this.newGameButton.setOffset(d2, this.newGameButton.getYOffset());
    }

    public void setScore(double d) {
        String string = MessageFormat.format(LABEL_SCORE, this.pointsFormat.format(d));
        this.scoreNode.setText(string);
    }

    public void setLevel(int n) {
        String string = MessageFormat.format(LABEL_LEVEL, String.valueOf(n));
        this.levelNode.setText(string);
    }

    public void setTimerVisible(boolean bl) {
        this.timerIcon.setVisible(bl);
        this.timerValue.setVisible(bl);
    }

    public void setTime(long l) {
        this.setTime(l, 0L);
    }

    public void setTime(long l, long l2) {
        String string = null;
        if (l2 == 0L) {
            string = GameTimerFormat.format(l);
        } else {
            String string2 = MessageFormat.format(LABEL_BEST, GameTimerFormat.format(l2));
            string = MessageFormat.format(FORMAT_TIME_BEST, GameTimerFormat.format(l), string2);
        }
        this.timerValue.setText(string);
    }

    public void setConfirmNewGame(boolean bl) {
        this.confirmNewGame = bl;
    }

    private void handleNewGame() {
        if (this.confirmNewGame) {
            PhetFrame phetFrame = PhetApplication.getInstance().getPhetFrame();
            int n = PhetOptionPane.showYesNoDialog(phetFrame, MESSAGE_CONFIRM_NEW_GAME, CONFIRM_TITLE);
            if (n == 0) {
                SimSharingManager.sendUserMessage(GameSimSharing.UserComponents.newGameYesButton, UserComponentTypes.button, UserActions.pressed);
                this.fireNewGamePressed();
            } else {
                SimSharingManager.sendUserMessage(GameSimSharing.UserComponents.newGameNoButton, UserComponentTypes.button, UserActions.pressed);
            }
        } else {
            this.fireNewGamePressed();
        }
    }

    private double getMaxChildHeight() {
        double d = 0.0;
        for (int i = 0; i < this.getChildrenCount(); ++i) {
            d = Math.max(d, this.getChild(i).getFullBoundsReference().getHeight());
        }
        return d;
    }

    public void addGameScoreboardListener(GameScoreboardListener gameScoreboardListener) {
        this.listeners.add(GameScoreboardListener.class, gameScoreboardListener);
    }

    private void fireNewGamePressed() {
        for (GameScoreboardListener gameScoreboardListener : (GameScoreboardListener[])this.listeners.getListeners(GameScoreboardListener.class)) {
            gameScoreboardListener.newGamePressed();
        }
    }

    public static interface GameScoreboardListener
    extends EventListener {
        public void newGamePressed();
    }
}

