/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.radiowaves.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.radiowaves.common_1200.graphics.PhetImageGraphic;
import edu.colorado.phet.radiowaves.model.Electron;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;

public class WaveMediumGraphic
extends PhetImageGraphic
implements SimpleObserver {
    private static double s_defaultStrokeWidth = 5.0;
    private static Stroke s_defaultStroke = new BasicStroke((float)s_defaultStrokeWidth);
    public static boolean Y_GRADIENT = false;
    private Electron electron;
    private Point2D origin;
    private double height = 15.0;
    private double stroke = 1.0;
    private boolean isPlanar = true;
    private float opacity = 1.0f;
    private double xExtent;
    private double xOffset = 15.0;
    private int direction;
    private Color maxAmplitudeColor = Color.red;
    private Paint[] colorForAmplitude = new Paint[255];

    private static BufferedImage createBufferedImage() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
        GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
        return graphicsConfiguration.createCompatibleImage(800, 800);
    }

    public WaveMediumGraphic(Electron electron, Component component, Point2D point2D, double d, int n) {
        super(component, WaveMediumGraphic.createBufferedImage());
        this.origin = point2D;
        this.xExtent = d;
        this.direction = n;
        this.electron = electron;
        electron.addObserver(this);
        this.setMaxAmplitudeColor(Color.red);
    }

    public void setMaxAmplitudeColor(Color color) {
        for (int i = 0; i < this.colorForAmplitude.length; ++i) {
            this.colorForAmplitude[i] = Y_GRADIENT ? new GradientPaint(0.0f, (int)(this.origin.getY() - this.height / 2.0), new Color(color.getRed(), color.getGreen(), color.getBlue(), 0), 0.0f, (int)this.origin.getY(), new Color(color.getRed(), color.getGreen(), color.getBlue(), i), true) : new Color(color.getRed(), color.getGreen(), color.getBlue(), i);
        }
    }

    private Paint getColorForAmplitude(double d) {
        double d2 = Math.min(1.0, Math.abs(d / 100.0));
        return this.colorForAmplitude[(int)(d2 * 254.0)];
    }

    private void setGraphicsHints(Graphics2D graphics2D) {
        graphics2D.setRenderingHint(RenderingHints.KEY_ALPHA_INTERPOLATION, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED);
        graphics2D.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_DITHERING, RenderingHints.VALUE_DITHER_DISABLE);
        graphics2D.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_OFF);
    }

    public void paint(Graphics2D graphics2D) {
        this.setGraphicsHints(graphics2D);
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.opacity));
        Point2D.Float float_ = new Point2D.Float();
        Point2D.Float float_2 = new Point2D.Float();
        Line2D.Float float_3 = new Line2D.Float();
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        double d = 1.0;
        while (d * (double)this.direction < this.xExtent) {
            graphics2D.setPaint(this.getColorForAmplitude(this.electron.getDynamicFieldAt(new Point2D.Double(this.origin.getX() + d, this.origin.getY())).getMagnitude()));
            if (this.isPlanar) {
                ((Point2D)float_).setLocation(this.origin.getX() + this.xOffset * (double)this.direction + d - s_defaultStrokeWidth / 2.0, this.origin.getY() - this.height / 2.0);
                ((Rectangle2D)double_).setRect(((Point2D)float_).getX(), ((Point2D)float_).getY(), s_defaultStrokeWidth, this.height);
                graphics2D.fill(double_);
            }
            d += s_defaultStrokeWidth * (double)this.direction;
        }
        graphics2D.setComposite(composite);
    }

    public void update() {
        this.repaint();
    }
}

