/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.radiowaves.view;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.TransformListener;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.radiowaves.EmfModule;
import edu.colorado.phet.radiowaves.common_1200.graphics.ApparatusPanel;
import edu.colorado.phet.radiowaves.common_1200.graphics.BoundedGraphic;
import edu.colorado.phet.radiowaves.common_1200.graphics.DefaultInteractiveGraphic;
import edu.colorado.phet.radiowaves.common_1200.graphics.Translatable;
import edu.colorado.phet.radiowaves.model.Electron;
import edu.colorado.phet.radiowaves.view.ElectronGraphic;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class TransmitterElectronGraphic
extends DefaultInteractiveGraphic
implements TransformListener,
BoundedGraphic,
Translatable {
    private static BufferedImage image;
    private ApparatusPanel apparatusPanel;
    private ElectronGraphic electronGraphic;
    private Electron electron;
    private EmfModule module;
    private Point dragPt;

    public TransmitterElectronGraphic(ApparatusPanel apparatusPanel, Electron electron, EmfModule emfModule) {
        super(null);
        this.electron = electron;
        this.module = emfModule;
        this.init(apparatusPanel, electron);
    }

    public void transformChanged(ModelViewTransform2D modelViewTransform2D) {
        this.electronGraphic.transformChanged(modelViewTransform2D);
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.dragPt = mouseEvent.getPoint();
        super.mouseDragged(mouseEvent);
    }

    public void translate(double d, double d2) {
        ModelViewTransform2D modelViewTransform2D = this.module.getMvTx();
        Point2D point2D = modelViewTransform2D.viewToModel(this.dragPt.x, this.dragPt.y);
        this.electron.moveToNewPosition(point2D);
    }

    public boolean contains(int n, int n2) {
        boolean bl = this.electronGraphic.contains(n, n2);
        return bl;
    }

    private void init(ApparatusPanel apparatusPanel, Electron electron) {
        this.apparatusPanel = apparatusPanel;
        this.electronGraphic = new ElectronGraphic(apparatusPanel, image, electron);
        super.setBoundary(this.electronGraphic);
        super.setGraphic(this.electronGraphic);
        electron.addObserver(this.electronGraphic);
        this.addCursorHandBehavior();
        this.addTranslationBehavior(this);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.module.removeWiggleMeGraphic();
    }

    static {
        try {
            image = ImageLoader.loadBufferedImage("radio-waves/images/blue-sml.gif");
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

