/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.radiowaves.view;

import edu.colorado.phet.common.phetcommon.math.ImmutableVector2D;
import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.Vector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.graphics.Arrow;
import edu.colorado.phet.common.phetcommon.view.util.DoubleGeneralPath;
import edu.colorado.phet.common.phetgraphics.view.util.GraphicsUtil;
import edu.colorado.phet.radiowaves.EmfConfig;
import edu.colorado.phet.radiowaves.common_1200.graphics.Graphic;
import edu.colorado.phet.radiowaves.model.Electron;
import edu.colorado.phet.radiowaves.view.graphics.splines.CubicSpline;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;

public class FieldLatticeView
implements SimpleObserver,
Graphic {
    private static int curveStartingIdx = 1;
    public static final Color curveColor = new Color(200, 0, 0);
    public static final Color arrowRed = EmfConfig.FORCE_COLOR;
    public static final Color arrowGreen = EmfConfig.FIELD_COLOR;
    private static int hollowArrowWidth = 5;
    private static int hollowArrowHeadWidth = 10;
    private static BasicStroke hollowArrowStroke = new BasicStroke(1.0f);
    private static BasicStroke curveStroke = new BasicStroke(1.0f);
    private static int s_latticePtDiam = 5;
    private static BufferedImage s_latticePtImg = new BufferedImage(s_latticePtDiam, s_latticePtDiam, 2);
    private Point transmittingElectronOrigin;
    private int latticeSpacingX;
    private int latticeSpacingY;
    private int numLatticePtsX;
    private int numLatticePtsY;
    private FieldPt[] latticePts;
    private ArrayList latticePtsNeg = new ArrayList();
    private ArrayList negArrows = new ArrayList();
    private ArrayList posArrows = new ArrayList();
    private ArrayList latticePtsPos = new ArrayList();
    private AffineTransform[] latticeTx;
    private Electron sourceElectron;
    private CubicSpline spline = new CubicSpline();
    private boolean autoscaleEnabled = false;
    private AffineTransform atx;
    private boolean displayStaticField;
    private boolean displayDynamicField;
    private int fieldSense = 1;
    private int fieldDisplayType;
    private boolean fieldDisplayAlphaEnabled = false;
    private ArrayList arrows = new ArrayList();
    private GeneralPath negPath;
    private GeneralPath posPath;
    private int firstArrowOffset = 25;
    private Component component;
    private boolean curveVisible = true;
    private boolean fixedSizeArrows = false;
    private int fullAlphaFieldMagnitude = 80;
    private BasicStroke arrowStroke = new BasicStroke(2.0f);

    public FieldLatticeView(Electron electron, Point point, int n, int n2, int n3, int n4, Component component) {
        this.component = component;
        if (this.fieldSense != 1 && this.fieldSense != -1) {
            throw new RuntimeException("Bad actual parameter: fieldSense ");
        }
        this.transmittingElectronOrigin = point;
        this.latticeSpacingX = n3;
        this.latticeSpacingY = n4;
        this.numLatticePtsX = 1 + (n - 1) / n3;
        this.numLatticePtsY = 1 + (n2 - 1) / n4;
        this.latticePts = new FieldPt[this.numLatticePtsY * this.numLatticePtsX];
        this.latticeTx = new AffineTransform[this.numLatticePtsY * this.numLatticePtsX];
        for (int i = 0; i < this.numLatticePtsY * this.numLatticePtsX; ++i) {
            this.latticePts[i] = new FieldPt(i % this.numLatticePtsX * n3, i / this.numLatticePtsX * n4);
            this.latticeTx[i] = new AffineTransform();
        }
        Point2D.Double double_ = new Point2D.Double(this.transmittingElectronOrigin.getX() - 0.001, this.transmittingElectronOrigin.getY());
        FieldPt fieldPt = new FieldPt(double_.getX(), double_.getY());
        this.latticePtsNeg.add(fieldPt);
        for (double d = (double)((int)this.transmittingElectronOrigin.getX() - this.firstArrowOffset); d >= (double)(-n3); d -= (double)n3) {
            FieldPt fieldPt2 = new FieldPt(d, this.transmittingElectronOrigin.getY());
            this.latticePtsNeg.add(fieldPt2);
            this.negArrows.add(new Arrow(new Point2D.Double(), new Point2D.Double(), 10.0, 10.0, 3.0, 0.5, false));
        }
        Point2D.Double double_2 = new Point2D.Double(this.transmittingElectronOrigin.getX() + 0.001, this.transmittingElectronOrigin.getY());
        this.latticePtsPos.add(new FieldPt(double_2.getX(), double_2.getY()));
        for (double d = (double)((int)this.transmittingElectronOrigin.getX() + this.firstArrowOffset); d < (double)n; d += (double)n3) {
            FieldPt fieldPt3 = new FieldPt(d, this.transmittingElectronOrigin.getY());
            this.latticePtsPos.add(fieldPt3);
            this.posArrows.add(new Arrow(new Point2D.Double(), new Point2D.Double(), 10.0, 10.0, 3.0, 0.5, false));
        }
        this.arrows.addAll(this.negArrows);
        this.arrows.addAll(this.posArrows);
        this.sourceElectron = electron;
        electron.addObserver(this);
        this.update();
    }

    public synchronized void paint(Graphics2D graphics2D) {
        Object object;
        Color color;
        RenderingHints renderingHints = graphics2D.getRenderingHints();
        GraphicsUtil.setAntiAliasingOn(graphics2D);
        AffineTransform affineTransform = graphics2D.getTransform();
        if (this.atx != null) {
            graphics2D.transform(this.atx);
        }
        Color color2 = color = this.fieldSense == 1 ? arrowRed : arrowGreen;
        if (this.fieldDisplayType == 4 || this.fieldDisplayType == 5) {
            graphics2D.setColor(color);
            graphics2D.setStroke(hollowArrowStroke);
            for (int i = 0; i < this.arrows.size(); ++i) {
                if (this.fieldDisplayAlphaEnabled) {
                    object = (Arrow)this.arrows.get(i);
                    double d = ((Arrow)object).getTipLocation().distance(((Arrow)object).getTailLocation());
                    double d2 = Math.min(1.0, d / (double)this.fullAlphaFieldMagnitude);
                    GraphicsUtil.setAlpha(graphics2D, d2);
                }
                object = (Arrow)this.arrows.get(i);
                graphics2D.draw(((Arrow)object).getShape());
            }
            GraphicsUtil.setAlpha(graphics2D, 1.0);
        }
        if (this.fieldDisplayType == 3 || this.fieldDisplayType == 4) {
            graphics2D.setColor(curveColor);
            graphics2D.setStroke(curveStroke);
            if (this.curveVisible && this.negPath != null && this.posPath != null) {
                RenderingHints renderingHints2 = graphics2D.getRenderingHints();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                if (!this.curveVisible) {
                    GraphicsUtil.setAlpha(graphics2D, 0.0);
                }
                graphics2D.draw(this.negPath);
                graphics2D.draw(this.posPath);
                graphics2D.setRenderingHints(renderingHints2);
            }
        }
        if (this.fieldDisplayType == 2) {
            Point2D.Double double_ = new Point2D.Double();
            object = new Point2D.Double();
            Arrow arrow = new Arrow(double_, (Point2D)object, 10.0, 10.0, 3.0, 0.5, true);
            graphics2D.setColor(color);
            graphics2D.setStroke(hollowArrowStroke);
            for (int i = 0; i < this.latticePts.length; ++i) {
                ImmutableVector2D immutableVector2D = this.latticePts[i].field.getScaledInstance(this.fieldSense);
                double d = immutableVector2D.getMagnitude();
                if (!(d > 3.0)) continue;
                double d3 = immutableVector2D.getAngle();
                ((Point2D)double_).setLocation(-d / 2.0, 0.0);
                ((Point2D)object).setLocation(d / 2.0, 0.0);
                arrow.setTailLocation(double_);
                arrow.setTipLocation((Point2D)object);
                AffineTransform affineTransform2 = graphics2D.getTransform();
                AffineTransform affineTransform3 = this.latticePts[i].tx;
                affineTransform3.setToTranslation(this.latticePts[i].location.getX(), this.latticePts[i].location.getY());
                affineTransform3.rotate(d3);
                graphics2D.transform(affineTransform3);
                if (this.fieldDisplayAlphaEnabled) {
                    double d4 = Math.min(1.0, d / (double)this.fullAlphaFieldMagnitude);
                    GraphicsUtil.setAlpha(graphics2D, d4);
                }
                graphics2D.draw(arrow.getShape());
                graphics2D.setTransform(affineTransform2);
            }
            GraphicsUtil.setAlpha(graphics2D, 1.0);
        }
        graphics2D.setTransform(affineTransform);
        GraphicsUtil.setAlpha(graphics2D, 1.0);
        graphics2D.setRenderingHints(renderingHints);
    }

    private void evaluateFieldPt(FieldPt fieldPt) {
        ImmutableVector2D immutableVector2D = null;
        if (this.displayStaticField && this.fieldDisplayType != 1) {
            immutableVector2D = this.sourceElectron.getStaticFieldAt(fieldPt.location);
        } else if (this.displayDynamicField && this.fieldDisplayType != 1) {
            immutableVector2D = this.sourceElectron.getDynamicFieldAt(fieldPt.location);
        }
        fieldPt.field.setComponents(immutableVector2D.getX(), immutableVector2D.getY());
    }

    public synchronized void update() {
        int n;
        if (this.fieldDisplayType == 2) {
            for (n = 0; n < this.latticePts.length; ++n) {
                this.evaluateFieldPt(this.latticePts[n]);
            }
        }
        if (this.fieldDisplayType == 3 || this.fieldDisplayType == 4 || this.fieldDisplayType == 5) {
            FieldPt fieldPt;
            for (n = 0; n < this.latticePtsNeg.size(); ++n) {
                fieldPt = (FieldPt)this.latticePtsNeg.get(n);
                this.evaluateFieldPt(fieldPt);
            }
            for (n = 0; n < this.latticePtsPos.size(); ++n) {
                fieldPt = (FieldPt)this.latticePtsPos.get(n);
                this.evaluateFieldPt(fieldPt);
            }
            this.negPath = this.createCurves(this.latticePtsNeg);
            this.posPath = this.createCurves(this.latticePtsPos);
            this.addArrows(this.negArrows, this.latticePtsNeg);
            this.addArrows(this.posArrows, this.latticePtsPos);
        }
    }

    private void addArrows(ArrayList arrayList, ArrayList arrayList2) {
        for (int i = 1; i < arrayList2.size(); ++i) {
            FieldPt fieldPt = (FieldPt)arrayList2.get(i);
            int n = MathUtil.getSign(fieldPt.field.getY()) * (this.fieldSense == 1 ? 1 : -1);
            double d = fieldPt.field.getMagnitude();
            if (this.fixedSizeArrows) {
                d = 50.0;
            }
            double d2 = fieldPt.getY() + d * (double)n;
            Arrow arrow = (Arrow)arrayList.get(i - 1);
            arrow.setTailLocation(new Point2D.Double(fieldPt.location.getX(), fieldPt.location.getY() - d * (double)n * EmfConfig.SINGLE_VECTOR_ROW_OFFSET));
            arrow.setTipLocation(new Point2D.Double(fieldPt.getX(), d2 -= d * (double)n * EmfConfig.SINGLE_VECTOR_ROW_OFFSET));
        }
    }

    private GeneralPath createCurves(ArrayList arrayList) {
        double d;
        double d2 = 1.0 - EmfConfig.SINGLE_VECTOR_ROW_OFFSET;
        FieldPt fieldPt = (FieldPt)arrayList.get(curveStartingIdx);
        int n = MathUtil.getSign(fieldPt.getX() - this.transmittingElectronOrigin.getX());
        DoubleGeneralPath doubleGeneralPath = new DoubleGeneralPath(fieldPt.getX(), fieldPt.getY() + fieldPt.field.getMagnitude() * (double)MathUtil.getSign(fieldPt.field.getY()) * d2);
        double d3 = d = fieldPt.field.getMagnitude() * (double)MathUtil.getSign(fieldPt.field.getY() * d2);
        double d4 = ((FieldPt)arrayList.get(arrayList.size() - 1)).getX();
        Point2D.Double double_ = new Point2D.Double();
        double d5 = fieldPt.getX();
        while (n > 0 ? d5 < d4 : d5 > d4) {
            double_.setLocation(new Point2D.Double(Math.abs(d5), this.transmittingElectronOrigin.getY()));
            Vector2D vector2D = this.sourceElectron.getDynamicFieldAt(double_);
            d3 = vector2D.getMagnitude() * (double)MathUtil.getSign(vector2D.getY());
            doubleGeneralPath.lineTo(d5, this.transmittingElectronOrigin.getY() + d3 * d2);
            d = d3;
            d5 += (double)(10 * n);
        }
        doubleGeneralPath.lineTo(d4, this.transmittingElectronOrigin.getY() + d3 * (double)n);
        return doubleGeneralPath.getGeneralPath();
    }

    public void setAutoscaleEnabled(boolean bl) {
        this.autoscaleEnabled = bl;
    }

    public void setDisplayStaticField(boolean bl) {
        this.displayStaticField = bl;
    }

    public void setDisplayDynamicField(boolean bl) {
        this.displayDynamicField = bl;
    }

    public void setFieldSense(int n) {
        this.fieldSense = n;
    }

    public void setDisplay(int n) {
        this.fieldDisplayType = n;
    }

    public void setTransform(AffineTransform affineTransform) {
        this.atx = affineTransform;
    }

    static {
        Graphics2D graphics2D = s_latticePtImg.createGraphics();
        graphics2D.dispose();
    }

    private class FieldPt {
        Point2D.Double location;
        Vector2D field = new Vector2D();
        AffineTransform tx = new AffineTransform();

        public FieldPt(double d, double d2) {
            this(new Point2D.Double(d, d2), new Vector2D());
        }

        public FieldPt(Point2D.Double double_, Vector2D vector2D) {
            this.location = new Point2D.Double(double_.getX(), double_.getY());
            this.field = new Vector2D(vector2D.getX(), vector2D.getY());
        }

        public double getX() {
            return this.location.x;
        }

        public double getY() {
            return this.location.y;
        }
    }
}

