/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.radiowaves.view;

import edu.colorado.phet.common.phetcommon.view.graphics.transforms.ModelViewTransform2D;
import edu.colorado.phet.common.phetcommon.view.graphics.transforms.TransformListener;
import edu.colorado.phet.common.phetcommon.view.util.BufferedImageUtils;
import edu.colorado.phet.common.phetcommon.view.util.ImageLoader;
import edu.colorado.phet.radiowaves.common_1200.graphics.ApparatusPanel;
import edu.colorado.phet.radiowaves.common_1200.graphics.BufferedImageGraphic;
import edu.colorado.phet.radiowaves.model.Electron;
import edu.colorado.phet.radiowaves.view.FieldLatticeView;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.IOException;

public class EmfPanel
extends ApparatusPanel
implements TransformListener {
    private static EmfPanel s_instance;
    private FieldLatticeView fieldLatticeView;
    private Dimension size = new Dimension();
    private BufferedImage bi;
    private boolean useBufferedImage = false;
    private AffineTransform atx;
    private BufferedImageGraphic backgroundImg;

    private static void setInstance(EmfPanel emfPanel) {
        s_instance = emfPanel;
    }

    public EmfPanel(Electron electron, Point point, int n, int n2) {
        EmfPanel.setInstance(this);
        int n3 = 50;
        int n4 = 50;
        this.fieldLatticeView = new FieldLatticeView(electron, point, n - n3, n2, n3, n4, this);
        this.addGraphic(this.fieldLatticeView, 4.0);
        try {
            BufferedImage bufferedImage = BufferedImageUtils.toBufferedImage(ImageLoader.loadBufferedImage("radio-waves/images/background.gif"));
            this.setPreferredSize(new Dimension(bufferedImage.getWidth(), bufferedImage.getHeight()));
            this.backgroundImg = new BufferedImageGraphic(bufferedImage);
            this.addGraphic(this.backgroundImg, 0.0);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    protected void paintComponent(Graphics graphics) {
        if (this.useBufferedImage) {
            if (this.size.getWidth() != this.getSize().getWidth() || this.size.getHeight() != this.getSize().getHeight()) {
                this.size.setSize(this.getSize());
                this.bi = new BufferedImage((int)this.size.getWidth(), (int)this.size.getHeight(), 1);
            }
            Graphics graphics2 = this.bi.getGraphics();
            super.paintComponent(graphics2);
            graphics.drawImage(this.bi, 0, 0, this);
            graphics2.dispose();
        } else {
            super.paintComponent(graphics);
        }
    }

    public void transformChanged(ModelViewTransform2D modelViewTransform2D) {
        this.atx = modelViewTransform2D.getAffineTransform();
        this.backgroundImg.setTransform(this.atx);
        this.fieldLatticeView.setTransform(this.atx);
    }

    public void setAutoscaleEnabled(boolean bl) {
        this.fieldLatticeView.setAutoscaleEnabled(bl);
    }

    public void displayStaticField(boolean bl) {
        this.fieldLatticeView.setDisplayStaticField(bl);
    }

    public void displayDynamicField(boolean bl) {
        this.fieldLatticeView.setDisplayDynamicField(bl);
    }

    public void setFieldSense(int n) {
        this.fieldLatticeView.setFieldSense(n);
    }

    public void setFieldDisplay(int n) {
        this.fieldLatticeView.setDisplay(n);
    }
}

